/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanProperties;
import com.azure.resourcemanager.appservice.models.DefaultIdentity;
import com.azure.resourcemanager.appservice.models.ExtendedLocation;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.InstallScript;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.RegistryAdapter;
import com.azure.resourcemanager.appservice.models.ServerFarmNetworkSettings;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.StatusOptions;
import com.azure.resourcemanager.appservice.models.StorageMount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AppServicePlanInner
extends Resource {
    private AppServicePlanProperties innerProperties;
    private SkuDescription sku;
    private ManagedServiceIdentity identity;
    private ExtendedLocation extendedLocation;
    private String kind;
    private String type;
    private String name;
    private String id;

    private AppServicePlanProperties innerProperties() {
        return this.innerProperties;
    }

    public SkuDescription sku() {
        return this.sku;
    }

    public AppServicePlanInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public AppServicePlanInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public AppServicePlanInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public AppServicePlanInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AppServicePlanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AppServicePlanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String workerTierName() {
        return this.innerProperties() == null ? null : this.innerProperties().workerTierName();
    }

    public AppServicePlanInner withWorkerTierName(String workerTierName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withWorkerTierName(workerTierName);
        return this;
    }

    public StatusOptions status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironmentProfile();
    }

    public AppServicePlanInner withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withHostingEnvironmentProfile(hostingEnvironmentProfile);
        return this;
    }

    public Integer maximumNumberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfWorkers();
    }

    public Integer numberOfWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfWorkers();
    }

    public String geoRegion() {
        return this.innerProperties() == null ? null : this.innerProperties().geoRegion();
    }

    public Boolean perSiteScaling() {
        return this.innerProperties() == null ? null : this.innerProperties().perSiteScaling();
    }

    public AppServicePlanInner withPerSiteScaling(Boolean perSiteScaling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withPerSiteScaling(perSiteScaling);
        return this;
    }

    public Boolean elasticScaleEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticScaleEnabled();
    }

    public AppServicePlanInner withElasticScaleEnabled(Boolean elasticScaleEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withElasticScaleEnabled(elasticScaleEnabled);
        return this;
    }

    public Integer maximumElasticWorkerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumElasticWorkerCount();
    }

    public AppServicePlanInner withMaximumElasticWorkerCount(Integer maximumElasticWorkerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withMaximumElasticWorkerCount(maximumElasticWorkerCount);
        return this;
    }

    public Integer numberOfSites() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfSites();
    }

    public Boolean isSpot() {
        return this.innerProperties() == null ? null : this.innerProperties().isSpot();
    }

    public AppServicePlanInner withIsSpot(Boolean isSpot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withIsSpot(isSpot);
        return this;
    }

    public OffsetDateTime spotExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().spotExpirationTime();
    }

    public AppServicePlanInner withSpotExpirationTime(OffsetDateTime spotExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withSpotExpirationTime(spotExpirationTime);
        return this;
    }

    public OffsetDateTime freeOfferExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().freeOfferExpirationTime();
    }

    public AppServicePlanInner withFreeOfferExpirationTime(OffsetDateTime freeOfferExpirationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withFreeOfferExpirationTime(freeOfferExpirationTime);
        return this;
    }

    public String resourceGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGroup();
    }

    public Boolean reserved() {
        return this.innerProperties() == null ? null : this.innerProperties().reserved();
    }

    public AppServicePlanInner withReserved(Boolean reserved) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withReserved(reserved);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public AppServicePlanInner withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public Boolean hyperV() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperV();
    }

    public AppServicePlanInner withHyperV(Boolean hyperV) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withHyperV(hyperV);
        return this;
    }

    public Integer targetWorkerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().targetWorkerCount();
    }

    public AppServicePlanInner withTargetWorkerCount(Integer targetWorkerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withTargetWorkerCount(targetWorkerCount);
        return this;
    }

    public Integer targetWorkerSizeId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetWorkerSizeId();
    }

    public AppServicePlanInner withTargetWorkerSizeId(Integer targetWorkerSizeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withTargetWorkerSizeId(targetWorkerSizeId);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public KubeEnvironmentProfile kubeEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().kubeEnvironmentProfile();
    }

    public AppServicePlanInner withKubeEnvironmentProfile(KubeEnvironmentProfile kubeEnvironmentProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withKubeEnvironmentProfile(kubeEnvironmentProfile);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public AppServicePlanInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public Boolean asyncScalingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().asyncScalingEnabled();
    }

    public AppServicePlanInner withAsyncScalingEnabled(Boolean asyncScalingEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withAsyncScalingEnabled(asyncScalingEnabled);
        return this;
    }

    public DefaultIdentity planDefaultIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().planDefaultIdentity();
    }

    public AppServicePlanInner withPlanDefaultIdentity(DefaultIdentity planDefaultIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withPlanDefaultIdentity(planDefaultIdentity);
        return this;
    }

    public Boolean isCustomMode() {
        return this.innerProperties() == null ? null : this.innerProperties().isCustomMode();
    }

    public AppServicePlanInner withIsCustomMode(Boolean isCustomMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withIsCustomMode(isCustomMode);
        return this;
    }

    public List<RegistryAdapter> registryAdapters() {
        return this.innerProperties() == null ? null : this.innerProperties().registryAdapters();
    }

    public AppServicePlanInner withRegistryAdapters(List<RegistryAdapter> registryAdapters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withRegistryAdapters(registryAdapters);
        return this;
    }

    public List<InstallScript> installScripts() {
        return this.innerProperties() == null ? null : this.innerProperties().installScripts();
    }

    public AppServicePlanInner withInstallScripts(List<InstallScript> installScripts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withInstallScripts(installScripts);
        return this;
    }

    public ServerFarmNetworkSettings network() {
        return this.innerProperties() == null ? null : this.innerProperties().network();
    }

    public AppServicePlanInner withNetwork(ServerFarmNetworkSettings network) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withNetwork(network);
        return this;
    }

    public List<StorageMount> storageMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().storageMounts();
    }

    public AppServicePlanInner withStorageMounts(List<StorageMount> storageMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withStorageMounts(storageMounts);
        return this;
    }

    public Boolean rdpEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().rdpEnabled();
    }

    public AppServicePlanInner withRdpEnabled(Boolean rdpEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServicePlanProperties();
        }
        this.innerProperties().withRdpEnabled(rdpEnabled);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static AppServicePlanInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppServicePlanInner)((Object)jsonReader.readObject(reader -> {
            AppServicePlanInner deserializedAppServicePlanInner = new AppServicePlanInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppServicePlanInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppServicePlanInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppServicePlanInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAppServicePlanInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAppServicePlanInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppServicePlanInner.innerProperties = AppServicePlanProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAppServicePlanInner.sku = SkuDescription.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAppServicePlanInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedAppServicePlanInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAppServicePlanInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServicePlanInner;
        }));
    }
}

