// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Web App stack minor version.
 */
@Immutable
public final class WebAppMinorVersion implements JsonSerializable<WebAppMinorVersion> {
    /*
     * Web App stack minor version (display only).
     */
    private String displayText;

    /*
     * Web App stack major version name.
     */
    private String value;

    /*
     * Settings associated with the minor version.
     */
    private WebAppRuntimes stackSettings;

    /**
     * Creates an instance of WebAppMinorVersion class.
     */
    public WebAppMinorVersion() {
    }

    /**
     * Get the displayText property: Web App stack minor version (display only).
     * 
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Get the value property: Web App stack major version name.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the stackSettings property: Settings associated with the minor version.
     * 
     * @return the stackSettings value.
     */
    public WebAppRuntimes stackSettings() {
        return this.stackSettings;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (stackSettings() != null) {
            stackSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebAppMinorVersion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebAppMinorVersion if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebAppMinorVersion.
     */
    public static WebAppMinorVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebAppMinorVersion deserializedWebAppMinorVersion = new WebAppMinorVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayText".equals(fieldName)) {
                    deserializedWebAppMinorVersion.displayText = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedWebAppMinorVersion.value = reader.getString();
                } else if ("stackSettings".equals(fieldName)) {
                    deserializedWebAppMinorVersion.stackSettings = WebAppRuntimes.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebAppMinorVersion;
        });
    }
}
