// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of the storage mount.
 */
public final class StorageMountType extends ExpandableStringEnum<StorageMountType> {
    /**
     * Static value AzureFiles for StorageMountType.
     */
    public static final StorageMountType AZURE_FILES = fromString("AzureFiles");

    /**
     * Static value LocalStorage for StorageMountType.
     */
    public static final StorageMountType LOCAL_STORAGE = fromString("LocalStorage");

    /**
     * Static value FileShare for StorageMountType.
     */
    public static final StorageMountType FILE_SHARE = fromString("FileShare");

    /**
     * Creates a new instance of StorageMountType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageMountType() {
    }

    /**
     * Creates or finds a StorageMountType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageMountType.
     */
    public static StorageMountType fromString(String name) {
        return fromString(name, StorageMountType.class);
    }

    /**
     * Gets known StorageMountType values.
     * 
     * @return known StorageMountType values.
     */
    public static Collection<StorageMountType> values() {
        return values(StorageMountType.class);
    }
}
