// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Server farm storage mount configuration.
 */
@Fluent
public final class StorageMount implements JsonSerializable<StorageMount> {
    /*
     * Name of the storage mount.
     */
    private String name;

    /*
     * Type of the storage mount.
     */
    private StorageMountType type;

    /*
     * Source of the fileshare/storage.
     */
    private String source;

    /*
     * Path on worker where storage will be mounted.
     */
    private String destinationPath;

    /*
     * KV reference to the credentials to connect to the share.
     */
    private KeyVaultReferenceWithStatus credentialsKeyVaultReference;

    /**
     * Creates an instance of StorageMount class.
     */
    public StorageMount() {
    }

    /**
     * Get the name property: Name of the storage mount.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the storage mount.
     * 
     * @param name the name value to set.
     * @return the StorageMount object itself.
     */
    public StorageMount withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Type of the storage mount.
     * 
     * @return the type value.
     */
    public StorageMountType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the storage mount.
     * 
     * @param type the type value to set.
     * @return the StorageMount object itself.
     */
    public StorageMount withType(StorageMountType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the source property: Source of the fileshare/storage.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: Source of the fileshare/storage.
     * 
     * @param source the source value to set.
     * @return the StorageMount object itself.
     */
    public StorageMount withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the destinationPath property: Path on worker where storage will be mounted.
     * 
     * @return the destinationPath value.
     */
    public String destinationPath() {
        return this.destinationPath;
    }

    /**
     * Set the destinationPath property: Path on worker where storage will be mounted.
     * 
     * @param destinationPath the destinationPath value to set.
     * @return the StorageMount object itself.
     */
    public StorageMount withDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
        return this;
    }

    /**
     * Get the credentialsKeyVaultReference property: KV reference to the credentials to connect to the share.
     * 
     * @return the credentialsKeyVaultReference value.
     */
    public KeyVaultReferenceWithStatus credentialsKeyVaultReference() {
        return this.credentialsKeyVaultReference;
    }

    /**
     * Set the credentialsKeyVaultReference property: KV reference to the credentials to connect to the share.
     * 
     * @param credentialsKeyVaultReference the credentialsKeyVaultReference value to set.
     * @return the StorageMount object itself.
     */
    public StorageMount withCredentialsKeyVaultReference(KeyVaultReferenceWithStatus credentialsKeyVaultReference) {
        this.credentialsKeyVaultReference = credentialsKeyVaultReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (credentialsKeyVaultReference() != null) {
            credentialsKeyVaultReference().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("destinationPath", this.destinationPath);
        jsonWriter.writeJsonField("credentialsKeyVaultReference", this.credentialsKeyVaultReference);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageMount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageMount if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageMount.
     */
    public static StorageMount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageMount deserializedStorageMount = new StorageMount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedStorageMount.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStorageMount.type = StorageMountType.fromString(reader.getString());
                } else if ("source".equals(fieldName)) {
                    deserializedStorageMount.source = reader.getString();
                } else if ("destinationPath".equals(fieldName)) {
                    deserializedStorageMount.destinationPath = reader.getString();
                } else if ("credentialsKeyVaultReference".equals(fieldName)) {
                    deserializedStorageMount.credentialsKeyVaultReference
                        = KeyVaultReferenceWithStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageMount;
        });
    }
}
