// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network settings for an app service plan.
 */
@Fluent
public final class ServerFarmNetworkSettings implements JsonSerializable<ServerFarmNetworkSettings> {
    /*
     * Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration. This must
     * be of the form
     * /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/
     * {vnetName}/subnets/{subnetName}
     */
    private String virtualNetworkSubnetId;

    /**
     * Creates an instance of ServerFarmNetworkSettings class.
     */
    public ServerFarmNetworkSettings() {
    }

    /**
     * Get the virtualNetworkSubnetId property: Azure Resource Manager ID of the Virtual network and subnet to be joined
     * by Regional VNET Integration. This must be of the form
     * /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     * 
     * @return the virtualNetworkSubnetId value.
     */
    public String virtualNetworkSubnetId() {
        return this.virtualNetworkSubnetId;
    }

    /**
     * Set the virtualNetworkSubnetId property: Azure Resource Manager ID of the Virtual network and subnet to be joined
     * by Regional VNET Integration. This must be of the form
     * /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     * 
     * @param virtualNetworkSubnetId the virtualNetworkSubnetId value to set.
     * @return the ServerFarmNetworkSettings object itself.
     */
    public ServerFarmNetworkSettings withVirtualNetworkSubnetId(String virtualNetworkSubnetId) {
        this.virtualNetworkSubnetId = virtualNetworkSubnetId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualNetworkSubnetId", this.virtualNetworkSubnetId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerFarmNetworkSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerFarmNetworkSettings if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerFarmNetworkSettings.
     */
    public static ServerFarmNetworkSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerFarmNetworkSettings deserializedServerFarmNetworkSettings = new ServerFarmNetworkSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetworkSubnetId".equals(fieldName)) {
                    deserializedServerFarmNetworkSettings.virtualNetworkSubnetId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerFarmNetworkSettings;
        });
    }
}
