// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents details of a single instance in a server farm.
 */
@Fluent
public final class ServerFarmInstance implements JsonSerializable<ServerFarmInstance> {
    /*
     * The instance name.
     */
    private String instanceName;

    /*
     * The instance IP address.
     */
    private String ipAddress;

    /*
     * The instance status.
     */
    private String status;

    /**
     * Creates an instance of ServerFarmInstance class.
     */
    public ServerFarmInstance() {
    }

    /**
     * Get the instanceName property: The instance name.
     * 
     * @return the instanceName value.
     */
    public String instanceName() {
        return this.instanceName;
    }

    /**
     * Set the instanceName property: The instance name.
     * 
     * @param instanceName the instanceName value to set.
     * @return the ServerFarmInstance object itself.
     */
    public ServerFarmInstance withInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    /**
     * Get the ipAddress property: The instance IP address.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The instance IP address.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the ServerFarmInstance object itself.
     */
    public ServerFarmInstance withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the status property: The instance status.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The instance status.
     * 
     * @param status the status value to set.
     * @return the ServerFarmInstance object itself.
     */
    public ServerFarmInstance withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceName", this.instanceName);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerFarmInstance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerFarmInstance if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerFarmInstance.
     */
    public static ServerFarmInstance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerFarmInstance deserializedServerFarmInstance = new ServerFarmInstance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceName".equals(fieldName)) {
                    deserializedServerFarmInstance.instanceName = reader.getString();
                } else if ("ipAddress".equals(fieldName)) {
                    deserializedServerFarmInstance.ipAddress = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedServerFarmInstance.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerFarmInstance;
        });
    }
}
