// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Server farm registry adapter configuration.
 */
@Fluent
public final class RegistryAdapter implements JsonSerializable<RegistryAdapter> {
    /*
     * Registry key for the adapter.
     */
    private String registryKey;

    /*
     * Type of the registry adapter.
     */
    private RegistryAdapterType type;

    /*
     * Key vault reference to the value that will be placed in the registry location
     */
    private KeyVaultReferenceWithStatus keyVaultSecretReference;

    /**
     * Creates an instance of RegistryAdapter class.
     */
    public RegistryAdapter() {
    }

    /**
     * Get the registryKey property: Registry key for the adapter.
     * 
     * @return the registryKey value.
     */
    public String registryKey() {
        return this.registryKey;
    }

    /**
     * Set the registryKey property: Registry key for the adapter.
     * 
     * @param registryKey the registryKey value to set.
     * @return the RegistryAdapter object itself.
     */
    public RegistryAdapter withRegistryKey(String registryKey) {
        this.registryKey = registryKey;
        return this;
    }

    /**
     * Get the type property: Type of the registry adapter.
     * 
     * @return the type value.
     */
    public RegistryAdapterType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the registry adapter.
     * 
     * @param type the type value to set.
     * @return the RegistryAdapter object itself.
     */
    public RegistryAdapter withType(RegistryAdapterType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the keyVaultSecretReference property: Key vault reference to the value that will be placed in the registry
     * location.
     * 
     * @return the keyVaultSecretReference value.
     */
    public KeyVaultReferenceWithStatus keyVaultSecretReference() {
        return this.keyVaultSecretReference;
    }

    /**
     * Set the keyVaultSecretReference property: Key vault reference to the value that will be placed in the registry
     * location.
     * 
     * @param keyVaultSecretReference the keyVaultSecretReference value to set.
     * @return the RegistryAdapter object itself.
     */
    public RegistryAdapter withKeyVaultSecretReference(KeyVaultReferenceWithStatus keyVaultSecretReference) {
        this.keyVaultSecretReference = keyVaultSecretReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultSecretReference() != null) {
            keyVaultSecretReference().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("registryKey", this.registryKey);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("keyVaultSecretReference", this.keyVaultSecretReference);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegistryAdapter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegistryAdapter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegistryAdapter.
     */
    public static RegistryAdapter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistryAdapter deserializedRegistryAdapter = new RegistryAdapter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("registryKey".equals(fieldName)) {
                    deserializedRegistryAdapter.registryKey = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRegistryAdapter.type = RegistryAdapterType.fromString(reader.getString());
                } else if ("keyVaultSecretReference".equals(fieldName)) {
                    deserializedRegistryAdapter.keyVaultSecretReference = KeyVaultReferenceWithStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegistryAdapter;
        });
    }
}
