// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Object to hold key vault reference and the resolution status.
 */
@Fluent
public final class KeyVaultReferenceWithStatus implements JsonSerializable<KeyVaultReferenceWithStatus> {
    /*
     * Key vault secret URI.
     */
    private String secretUri;

    /*
     * Reference status of the key vault secret.
     */
    private String referenceStatus;

    /**
     * Creates an instance of KeyVaultReferenceWithStatus class.
     */
    public KeyVaultReferenceWithStatus() {
    }

    /**
     * Get the secretUri property: Key vault secret URI.
     * 
     * @return the secretUri value.
     */
    public String secretUri() {
        return this.secretUri;
    }

    /**
     * Set the secretUri property: Key vault secret URI.
     * 
     * @param secretUri the secretUri value to set.
     * @return the KeyVaultReferenceWithStatus object itself.
     */
    public KeyVaultReferenceWithStatus withSecretUri(String secretUri) {
        this.secretUri = secretUri;
        return this;
    }

    /**
     * Get the referenceStatus property: Reference status of the key vault secret.
     * 
     * @return the referenceStatus value.
     */
    public String referenceStatus() {
        return this.referenceStatus;
    }

    /**
     * Set the referenceStatus property: Reference status of the key vault secret.
     * 
     * @param referenceStatus the referenceStatus value to set.
     * @return the KeyVaultReferenceWithStatus object itself.
     */
    public KeyVaultReferenceWithStatus withReferenceStatus(String referenceStatus) {
        this.referenceStatus = referenceStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretUri", this.secretUri);
        jsonWriter.writeStringField("referenceStatus", this.referenceStatus);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultReferenceWithStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultReferenceWithStatus if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyVaultReferenceWithStatus.
     */
    public static KeyVaultReferenceWithStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultReferenceWithStatus deserializedKeyVaultReferenceWithStatus = new KeyVaultReferenceWithStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secretUri".equals(fieldName)) {
                    deserializedKeyVaultReferenceWithStatus.secretUri = reader.getString();
                } else if ("referenceStatus".equals(fieldName)) {
                    deserializedKeyVaultReferenceWithStatus.referenceStatus = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultReferenceWithStatus;
        });
    }
}
