// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of the install script.
 */
public final class InstallScriptType extends ExpandableStringEnum<InstallScriptType> {
    /**
     * Static value RemoteAzureBlob for InstallScriptType.
     */
    public static final InstallScriptType REMOTE_AZURE_BLOB = fromString("RemoteAzureBlob");

    /**
     * Static value PlatformStorage for InstallScriptType.
     */
    public static final InstallScriptType PLATFORM_STORAGE = fromString("PlatformStorage");

    /**
     * Creates a new instance of InstallScriptType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public InstallScriptType() {
    }

    /**
     * Creates or finds a InstallScriptType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding InstallScriptType.
     */
    public static InstallScriptType fromString(String name) {
        return fromString(name, InstallScriptType.class);
    }

    /**
     * Gets known InstallScriptType values.
     * 
     * @return known InstallScriptType values.
     */
    public static Collection<InstallScriptType> values() {
        return values(InstallScriptType.class);
    }
}
