// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Object to hold install script reference.
 */
@Fluent
public final class InstallScriptSource implements JsonSerializable<InstallScriptSource> {
    /*
     * Install script source URI where the install script file will be fetched from.
     */
    private String sourceUri;

    /*
     * Type of the install script.
     */
    private InstallScriptType type;

    /**
     * Creates an instance of InstallScriptSource class.
     */
    public InstallScriptSource() {
    }

    /**
     * Get the sourceUri property: Install script source URI where the install script file will be fetched from.
     * 
     * @return the sourceUri value.
     */
    public String sourceUri() {
        return this.sourceUri;
    }

    /**
     * Set the sourceUri property: Install script source URI where the install script file will be fetched from.
     * 
     * @param sourceUri the sourceUri value to set.
     * @return the InstallScriptSource object itself.
     */
    public InstallScriptSource withSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
        return this;
    }

    /**
     * Get the type property: Type of the install script.
     * 
     * @return the type value.
     */
    public InstallScriptType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the install script.
     * 
     * @param type the type value to set.
     * @return the InstallScriptSource object itself.
     */
    public InstallScriptSource withType(InstallScriptType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceUri", this.sourceUri);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InstallScriptSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InstallScriptSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the InstallScriptSource.
     */
    public static InstallScriptSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InstallScriptSource deserializedInstallScriptSource = new InstallScriptSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceUri".equals(fieldName)) {
                    deserializedInstallScriptSource.sourceUri = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedInstallScriptSource.type = InstallScriptType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInstallScriptSource;
        });
    }
}
