// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Server farm install script configuration.
 */
@Fluent
public final class InstallScript implements JsonSerializable<InstallScript> {
    /*
     * Name of the install script.
     */
    private String name;

    /*
     * Source of the install script.
     */
    private InstallScriptSource source;

    /**
     * Creates an instance of InstallScript class.
     */
    public InstallScript() {
    }

    /**
     * Get the name property: Name of the install script.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the install script.
     * 
     * @param name the name value to set.
     * @return the InstallScript object itself.
     */
    public InstallScript withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the source property: Source of the install script.
     * 
     * @return the source value.
     */
    public InstallScriptSource source() {
        return this.source;
    }

    /**
     * Set the source property: Source of the install script.
     * 
     * @param source the source value to set.
     * @return the InstallScript object itself.
     */
    public InstallScript withSource(InstallScriptSource source) {
        this.source = source;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() != null) {
            source().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InstallScript from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InstallScript if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the InstallScript.
     */
    public static InstallScript fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InstallScript deserializedInstallScript = new InstallScript();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedInstallScript.name = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedInstallScript.source = InstallScriptSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInstallScript;
        });
    }
}
