// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The DefaultIdentity model.
 */
@Fluent
public final class DefaultIdentity implements JsonSerializable<DefaultIdentity> {
    /*
     * The identityType property.
     */
    private ManagedServiceIdentityType identityType;

    /*
     * The userAssignedIdentityResourceId property.
     */
    private String userAssignedIdentityResourceId;

    /**
     * Creates an instance of DefaultIdentity class.
     */
    public DefaultIdentity() {
    }

    /**
     * Get the identityType property: The identityType property.
     * 
     * @return the identityType value.
     */
    public ManagedServiceIdentityType identityType() {
        return this.identityType;
    }

    /**
     * Set the identityType property: The identityType property.
     * 
     * @param identityType the identityType value to set.
     * @return the DefaultIdentity object itself.
     */
    public DefaultIdentity withIdentityType(ManagedServiceIdentityType identityType) {
        this.identityType = identityType;
        return this;
    }

    /**
     * Get the userAssignedIdentityResourceId property: The userAssignedIdentityResourceId property.
     * 
     * @return the userAssignedIdentityResourceId value.
     */
    public String userAssignedIdentityResourceId() {
        return this.userAssignedIdentityResourceId;
    }

    /**
     * Set the userAssignedIdentityResourceId property: The userAssignedIdentityResourceId property.
     * 
     * @param userAssignedIdentityResourceId the userAssignedIdentityResourceId value to set.
     * @return the DefaultIdentity object itself.
     */
    public DefaultIdentity withUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
        this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("identityType", this.identityType == null ? null : this.identityType.toString());
        jsonWriter.writeStringField("userAssignedIdentityResourceId", this.userAssignedIdentityResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DefaultIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DefaultIdentity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DefaultIdentity.
     */
    public static DefaultIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DefaultIdentity deserializedDefaultIdentity = new DefaultIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identityType".equals(fieldName)) {
                    deserializedDefaultIdentity.identityType
                        = ManagedServiceIdentityType.fromString(reader.getString());
                } else if ("userAssignedIdentityResourceId".equals(fieldName)) {
                    deserializedDefaultIdentity.userAssignedIdentityResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDefaultIdentity;
        });
    }
}
