// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The correlation property.
 */
@Fluent
public final class Correlation implements JsonSerializable<Correlation> {
    /*
     * The client tracking id.
     */
    private String clientTrackingId;

    /**
     * Creates an instance of Correlation class.
     */
    public Correlation() {
    }

    /**
     * Get the clientTrackingId property: The client tracking id.
     * 
     * @return the clientTrackingId value.
     */
    public String clientTrackingId() {
        return this.clientTrackingId;
    }

    /**
     * Set the clientTrackingId property: The client tracking id.
     * 
     * @param clientTrackingId the clientTrackingId value to set.
     * @return the Correlation object itself.
     */
    public Correlation withClientTrackingId(String clientTrackingId) {
        this.clientTrackingId = clientTrackingId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientTrackingId", this.clientTrackingId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Correlation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Correlation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Correlation.
     */
    public static Correlation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Correlation deserializedCorrelation = new Correlation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientTrackingId".equals(fieldName)) {
                    deserializedCorrelation.clientTrackingId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCorrelation;
        });
    }
}
