// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appservice.fluent.ProvidersClient;
import com.azure.resourcemanager.appservice.fluent.models.ApplicationStackResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmOperationDescriptionInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionAppStackInner;
import com.azure.resourcemanager.appservice.fluent.models.WebAppStackInner;
import com.azure.resourcemanager.appservice.models.ApplicationStackCollection;
import com.azure.resourcemanager.appservice.models.CsmOperationCollection;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.FunctionAppStackCollection;
import com.azure.resourcemanager.appservice.models.ProviderOsTypeSelected;
import com.azure.resourcemanager.appservice.models.ProviderStackOsType;
import com.azure.resourcemanager.appservice.models.WebAppStackCollection;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ProvidersClient.
 */
public final class ProvidersClientImpl implements ProvidersClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ProvidersService service;

    /**
     * The service client containing this operation class.
     */
    private final WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of ProvidersClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ProvidersClientImpl(WebSiteManagementClientImpl client) {
        this.service
            = RestProxy.create(ProvidersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for WebSiteManagementClientProviders to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "WebSiteManagementClientProviders")
    public interface ProvidersService {
        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Web/availableStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApplicationStackCollection>> getAvailableStacks(@HostParam("$host") String endpoint,
            @QueryParam("osTypeSelected") ProviderOsTypeSelected osTypeSelected,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Web/functionAppStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionAppStackCollection>> getFunctionAppStacks(@HostParam("$host") String endpoint,
            @QueryParam("stackOsType") ProviderStackOsType stackOsType, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Web/locations/{location}/functionAppStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionAppStackCollection>> getFunctionAppStacksForLocation(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @QueryParam("stackOsType") ProviderStackOsType stackOsType,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Web/locations/{location}/webAppStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppStackCollection>> getWebAppStacksForLocation(@HostParam("$host") String endpoint,
            @PathParam("location") String location, @QueryParam("stackOsType") ProviderStackOsType stackOsType,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Web/operations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmOperationCollection>> listOperations(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Web/webAppStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppStackCollection>> getWebAppStacks(@HostParam("$host") String endpoint,
            @QueryParam("stackOsType") ProviderStackOsType stackOsType, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApplicationStackCollection>> list(@HostParam("$host") String endpoint,
            @QueryParam("osTypeSelected") ProviderOsTypeSelected osTypeSelected,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApplicationStackCollection>> getAvailableStacksNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionAppStackCollection>> getFunctionAppStacksNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<FunctionAppStackCollection>> getFunctionAppStacksForLocationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppStackCollection>> getWebAppStacksForLocationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<CsmOperationCollection>> listOperationsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<WebAppStackCollection>> getWebAppStacksNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<ApplicationStackCollection>> getAvailableStacksOnPremNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>>
        getAvailableStacksSinglePageAsync(ProviderOsTypeSelected osTypeSelected) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAvailableStacks(this.client.getEndpoint(), osTypeSelected, apiVersion,
                accept, context))
            .<PagedResponse<ApplicationStackResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>>
        getAvailableStacksSinglePageAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAvailableStacks(this.client.getEndpoint(), osTypeSelected, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync(ProviderOsTypeSelected osTypeSelected) {
        return new PagedFlux<>(() -> getAvailableStacksSinglePageAsync(osTypeSelected),
            nextLink -> getAvailableStacksNextSinglePageAsync(nextLink));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync() {
        final ProviderOsTypeSelected osTypeSelected = null;
        return new PagedFlux<>(() -> getAvailableStacksSinglePageAsync(osTypeSelected),
            nextLink -> getAvailableStacksNextSinglePageAsync(nextLink));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApplicationStackResourceInner> getAvailableStacksAsync(ProviderOsTypeSelected osTypeSelected,
        Context context) {
        return new PagedFlux<>(() -> getAvailableStacksSinglePageAsync(osTypeSelected, context),
            nextLink -> getAvailableStacksNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> getAvailableStacks() {
        final ProviderOsTypeSelected osTypeSelected = null;
        return new PagedIterable<>(getAvailableStacksAsync(osTypeSelected));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> getAvailableStacks(ProviderOsTypeSelected osTypeSelected,
        Context context) {
        return new PagedIterable<>(getAvailableStacksAsync(osTypeSelected, context));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>>
        getFunctionAppStacksSinglePageAsync(ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getFunctionAppStacks(this.client.getEndpoint(), stackOsType, apiVersion,
                accept, context))
            .<PagedResponse<FunctionAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>>
        getFunctionAppStacksSinglePageAsync(ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getFunctionAppStacks(this.client.getEndpoint(), stackOsType, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksAsync(ProviderStackOsType stackOsType) {
        return new PagedFlux<>(() -> getFunctionAppStacksSinglePageAsync(stackOsType),
            nextLink -> getFunctionAppStacksNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksAsync() {
        final ProviderStackOsType stackOsType = null;
        return new PagedFlux<>(() -> getFunctionAppStacksSinglePageAsync(stackOsType),
            nextLink -> getFunctionAppStacksNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FunctionAppStackInner> getFunctionAppStacksAsync(ProviderStackOsType stackOsType,
        Context context) {
        return new PagedFlux<>(() -> getFunctionAppStacksSinglePageAsync(stackOsType, context),
            nextLink -> getFunctionAppStacksNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacks() {
        final ProviderStackOsType stackOsType = null;
        return new PagedIterable<>(getFunctionAppStacksAsync(stackOsType));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Description for Get available Function app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacks(ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<>(getFunctionAppStacksAsync(stackOsType, context));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksForLocationSinglePageAsync(String location,
        ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getFunctionAppStacksForLocation(this.client.getEndpoint(), location,
                stackOsType, apiVersion, accept, context))
            .<PagedResponse<FunctionAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksForLocationSinglePageAsync(String location,
        ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getFunctionAppStacksForLocation(this.client.getEndpoint(), location, stackOsType, apiVersion, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksForLocationAsync(String location,
        ProviderStackOsType stackOsType) {
        return new PagedFlux<>(() -> getFunctionAppStacksForLocationSinglePageAsync(location, stackOsType),
            nextLink -> getFunctionAppStacksForLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FunctionAppStackInner> getFunctionAppStacksForLocationAsync(String location) {
        final ProviderStackOsType stackOsType = null;
        return new PagedFlux<>(() -> getFunctionAppStacksForLocationSinglePageAsync(location, stackOsType),
            nextLink -> getFunctionAppStacksForLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FunctionAppStackInner> getFunctionAppStacksForLocationAsync(String location,
        ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<>(() -> getFunctionAppStacksForLocationSinglePageAsync(location, stackOsType, context),
            nextLink -> getFunctionAppStacksForLocationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacksForLocation(String location) {
        final ProviderStackOsType stackOsType = null;
        return new PagedIterable<>(getFunctionAppStacksForLocationAsync(location, stackOsType));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Description for Get available Function app frameworks and their versions for location.
     * 
     * @param location Function App stack location.
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FunctionAppStackInner> getFunctionAppStacksForLocation(String location,
        ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<>(getFunctionAppStacksForLocationAsync(location, stackOsType, context));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationSinglePageAsync(String location,
        ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getWebAppStacksForLocation(this.client.getEndpoint(), location, stackOsType,
                apiVersion, accept, context))
            .<PagedResponse<WebAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationSinglePageAsync(String location,
        ProviderStackOsType stackOsType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getWebAppStacksForLocation(this.client.getEndpoint(), location, stackOsType, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksForLocationAsync(String location,
        ProviderStackOsType stackOsType) {
        return new PagedFlux<>(() -> getWebAppStacksForLocationSinglePageAsync(location, stackOsType),
            nextLink -> getWebAppStacksForLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksForLocationAsync(String location) {
        final ProviderStackOsType stackOsType = null;
        return new PagedFlux<>(() -> getWebAppStacksForLocationSinglePageAsync(location, stackOsType),
            nextLink -> getWebAppStacksForLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<WebAppStackInner> getWebAppStacksForLocationAsync(String location,
        ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<>(() -> getWebAppStacksForLocationSinglePageAsync(location, stackOsType, context),
            nextLink -> getWebAppStacksForLocationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacksForLocation(String location) {
        final ProviderStackOsType stackOsType = null;
        return new PagedIterable<>(getWebAppStacksForLocationAsync(location, stackOsType));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Description for Get available Web app frameworks and their versions for location.
     * 
     * @param location Web App stack location.
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacksForLocation(String location, ProviderStackOsType stackOsType,
        Context context) {
        return new PagedIterable<>(getWebAppStacksForLocationAsync(location, stackOsType, context));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource
     * metric definitions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOperations(this.client.getEndpoint(), apiVersion, accept, context))
            .<PagedResponse<CsmOperationDescriptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource
     * metric definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listOperations(this.client.getEndpoint(), apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource
     * metric definitions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CsmOperationDescriptionInner> listOperationsAsync() {
        return new PagedFlux<>(() -> listOperationsSinglePageAsync(),
            nextLink -> listOperationsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource
     * metric definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<CsmOperationDescriptionInner> listOperationsAsync(Context context) {
        return new PagedFlux<>(() -> listOperationsSinglePageAsync(context),
            nextLink -> listOperationsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource
     * metric definitions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CsmOperationDescriptionInner> listOperations() {
        return new PagedIterable<>(listOperationsAsync());
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes resource
     * metric definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CsmOperationDescriptionInner> listOperations(Context context) {
        return new PagedIterable<>(listOperationsAsync(context));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksSinglePageAsync(ProviderStackOsType stackOsType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getWebAppStacks(this.client.getEndpoint(), stackOsType, apiVersion, accept, context))
            .<PagedResponse<WebAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksSinglePageAsync(ProviderStackOsType stackOsType,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getWebAppStacks(this.client.getEndpoint(), stackOsType, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksAsync(ProviderStackOsType stackOsType) {
        return new PagedFlux<>(() -> getWebAppStacksSinglePageAsync(stackOsType),
            nextLink -> getWebAppStacksNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<WebAppStackInner> getWebAppStacksAsync() {
        final ProviderStackOsType stackOsType = null;
        return new PagedFlux<>(() -> getWebAppStacksSinglePageAsync(stackOsType),
            nextLink -> getWebAppStacksNextSinglePageAsync(nextLink));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<WebAppStackInner> getWebAppStacksAsync(ProviderStackOsType stackOsType, Context context) {
        return new PagedFlux<>(() -> getWebAppStacksSinglePageAsync(stackOsType, context),
            nextLink -> getWebAppStacksNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacks() {
        final ProviderStackOsType stackOsType = null;
        return new PagedIterable<>(getWebAppStacksAsync(stackOsType));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Description for Get available Web app frameworks and their versions.
     * 
     * @param stackOsType Stack OS Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<WebAppStackInner> getWebAppStacks(ProviderStackOsType stackOsType, Context context) {
        return new PagedIterable<>(getWebAppStacksAsync(stackOsType, context));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>>
        listSinglePageAsync(ProviderOsTypeSelected osTypeSelected) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), osTypeSelected,
                this.client.getSubscriptionId(), apiVersion, accept, context))
            .<PagedResponse<ApplicationStackResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>>
        listSinglePageAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), osTypeSelected, this.client.getSubscriptionId(), apiVersion, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> listAsync(ProviderOsTypeSelected osTypeSelected) {
        return new PagedFlux<>(() -> listSinglePageAsync(osTypeSelected),
            nextLink -> getAvailableStacksOnPremNextSinglePageAsync(nextLink));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ApplicationStackResourceInner> listAsync() {
        final ProviderOsTypeSelected osTypeSelected = null;
        return new PagedFlux<>(() -> listSinglePageAsync(osTypeSelected),
            nextLink -> getAvailableStacksOnPremNextSinglePageAsync(nextLink));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ApplicationStackResourceInner> listAsync(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(osTypeSelected, context),
            nextLink -> getAvailableStacksOnPremNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> list() {
        final ProviderOsTypeSelected osTypeSelected = null;
        return new PagedIterable<>(listAsync(osTypeSelected));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Description for Get available application frameworks and their versions.
     * 
     * @param osTypeSelected The osTypeSelected parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ApplicationStackResourceInner> list(ProviderOsTypeSelected osTypeSelected, Context context) {
        return new PagedIterable<>(listAsync(osTypeSelected, context));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getAvailableStacksNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ApplicationStackResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>> getAvailableStacksNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAvailableStacksNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getFunctionAppStacksNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<FunctionAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Function app frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>> getFunctionAppStacksNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getFunctionAppStacksNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>>
        getFunctionAppStacksForLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getFunctionAppStacksForLocationNext(nextLink, this.client.getEndpoint(),
                accept, context))
            .<PagedResponse<FunctionAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Function app frameworks and their versions for location
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Function app Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionAppStackInner>>
        getFunctionAppStacksForLocationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getFunctionAppStacksForLocationNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getWebAppStacksForLocationNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<WebAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Web app frameworks and their versions for location
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksForLocationNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getWebAppStacksForLocationNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOperationsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<CsmOperationDescriptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all available operations for the Microsoft.Web resource provider. Also exposes resource metric definitions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Azure resource manager operation metadata along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<CsmOperationDescriptionInner>> listOperationsNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listOperationsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getWebAppStacksNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<WebAppStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available Web app frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Web app Stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebAppStackInner>> getWebAppStacksNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getWebAppStacksNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>>
        getAvailableStacksOnPremNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getAvailableStacksOnPremNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ApplicationStackResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get available application frameworks and their versions
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Application Stacks along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ApplicationStackResourceInner>>
        getAvailableStacksOnPremNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAvailableStacksOnPremNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
