// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.RetryHistory;
import com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The workflow run action properties.
 */
@Fluent
public final class WorkflowRunActionProperties implements JsonSerializable<WorkflowRunActionProperties> {
    /*
     * Gets the start time.
     */
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    private OffsetDateTime endTime;

    /*
     * Gets the status.
     */
    private WorkflowStatus status;

    /*
     * Gets the code.
     */
    private String code;

    /*
     * Gets the error.
     */
    private Object error;

    /*
     * Gets the tracking id.
     */
    private String trackingId;

    /*
     * The correlation properties.
     */
    private RunActionCorrelation correlation;

    /*
     * Gets the link to inputs.
     */
    private ContentLink inputsLink;

    /*
     * Gets the link to outputs.
     */
    private ContentLink outputsLink;

    /*
     * Gets the tracked properties.
     */
    private Object trackedProperties;

    /*
     * Gets the retry histories.
     */
    private List<RetryHistory> retryHistory;

    /**
     * Creates an instance of WorkflowRunActionProperties class.
     */
    public WorkflowRunActionProperties() {
    }

    /**
     * Get the startTime property: Gets the start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the status property: Gets the status.
     * 
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the code property: Gets the code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error property: Gets the error.
     * 
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     * 
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.trackingId;
    }

    /**
     * Get the correlation property: The correlation properties.
     * 
     * @return the correlation value.
     */
    public RunActionCorrelation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The correlation properties.
     * 
     * @param correlation the correlation value to set.
     * @return the WorkflowRunActionProperties object itself.
     */
    public WorkflowRunActionProperties withCorrelation(RunActionCorrelation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to inputs.
     * 
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    /**
     * Get the outputsLink property: Gets the link to outputs.
     * 
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    /**
     * Get the trackedProperties property: Gets the tracked properties.
     * 
     * @return the trackedProperties value.
     */
    public Object trackedProperties() {
        return this.trackedProperties;
    }

    /**
     * Get the retryHistory property: Gets the retry histories.
     * 
     * @return the retryHistory value.
     */
    public List<RetryHistory> retryHistory() {
        return this.retryHistory;
    }

    /**
     * Set the retryHistory property: Gets the retry histories.
     * 
     * @param retryHistory the retryHistory value to set.
     * @return the WorkflowRunActionProperties object itself.
     */
    public WorkflowRunActionProperties withRetryHistory(List<RetryHistory> retryHistory) {
        this.retryHistory = retryHistory;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (correlation() != null) {
            correlation().validate();
        }
        if (inputsLink() != null) {
            inputsLink().validate();
        }
        if (outputsLink() != null) {
            outputsLink().validate();
        }
        if (retryHistory() != null) {
            retryHistory().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        jsonWriter.writeArrayField("retryHistory", this.retryHistory, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowRunActionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowRunActionProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowRunActionProperties.
     */
    public static WorkflowRunActionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunActionProperties deserializedWorkflowRunActionProperties = new WorkflowRunActionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.status = WorkflowStatus.fromString(reader.getString());
                } else if ("code".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.code = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.error = reader.readUntyped();
                } else if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.trackingId = reader.getString();
                } else if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.correlation = RunActionCorrelation.fromJson(reader);
                } else if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.inputsLink = ContentLink.fromJson(reader);
                } else if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.outputsLink = ContentLink.fromJson(reader);
                } else if ("trackedProperties".equals(fieldName)) {
                    deserializedWorkflowRunActionProperties.trackedProperties = reader.readUntyped();
                } else if ("retryHistory".equals(fieldName)) {
                    List<RetryHistory> retryHistory = reader.readArray(reader1 -> RetryHistory.fromJson(reader1));
                    deserializedWorkflowRunActionProperties.retryHistory = retryHistory;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowRunActionProperties;
        });
    }
}
