// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.Kind;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * The workflow properties.
 */
@Fluent
public final class WorkflowProperties implements JsonSerializable<WorkflowProperties> {
    /*
     * Gets the provisioning state.
     */
    private WorkflowProvisioningState provisioningState;

    /*
     * Gets the created time.
     */
    private OffsetDateTime createdTime;

    /*
     * Gets the changed time.
     */
    private OffsetDateTime changedTime;

    /*
     * The state.
     */
    private WorkflowState state;

    /*
     * Gets the version.
     */
    private String version;

    /*
     * Gets the access endpoint.
     */
    private String accessEndpoint;

    /*
     * The endpoints configuration.
     */
    private FlowEndpointsConfiguration endpointsConfiguration;

    /*
     * The access control configuration.
     */
    private FlowAccessControlConfiguration accessControl;

    /*
     * The sku.
     */
    private WorkflowSku sku;

    /*
     * The integration account.
     */
    private ResourceReference integrationAccount;

    /*
     * The integration service environment.
     */
    private ResourceReference integrationServiceEnvironment;

    /*
     * The definition.
     */
    private Object definition;

    /*
     * The parameters.
     */
    private Map<String, WorkflowParameter> parameters;

    /*
     * The workflow kind.
     */
    private Kind kind;

    /**
     * Creates an instance of WorkflowProperties class.
     */
    public WorkflowProperties() {
    }

    /**
     * Get the provisioningState property: Gets the provisioning state.
     * 
     * @return the provisioningState value.
     */
    public WorkflowProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the createdTime property: Gets the created time.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the changedTime property: Gets the changed time.
     * 
     * @return the changedTime value.
     */
    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    /**
     * Get the state property: The state.
     * 
     * @return the state value.
     */
    public WorkflowState state() {
        return this.state;
    }

    /**
     * Set the state property: The state.
     * 
     * @param state the state value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withState(WorkflowState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the version property: Gets the version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the accessEndpoint property: Gets the access endpoint.
     * 
     * @return the accessEndpoint value.
     */
    public String accessEndpoint() {
        return this.accessEndpoint;
    }

    /**
     * Get the endpointsConfiguration property: The endpoints configuration.
     * 
     * @return the endpointsConfiguration value.
     */
    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.endpointsConfiguration;
    }

    /**
     * Set the endpointsConfiguration property: The endpoints configuration.
     * 
     * @param endpointsConfiguration the endpointsConfiguration value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        this.endpointsConfiguration = endpointsConfiguration;
        return this;
    }

    /**
     * Get the accessControl property: The access control configuration.
     * 
     * @return the accessControl value.
     */
    public FlowAccessControlConfiguration accessControl() {
        return this.accessControl;
    }

    /**
     * Set the accessControl property: The access control configuration.
     * 
     * @param accessControl the accessControl value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withAccessControl(FlowAccessControlConfiguration accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    /**
     * Get the sku property: The sku.
     * 
     * @return the sku value.
     */
    public WorkflowSku sku() {
        return this.sku;
    }

    /**
     * Get the integrationAccount property: The integration account.
     * 
     * @return the integrationAccount value.
     */
    public ResourceReference integrationAccount() {
        return this.integrationAccount;
    }

    /**
     * Set the integrationAccount property: The integration account.
     * 
     * @param integrationAccount the integrationAccount value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withIntegrationAccount(ResourceReference integrationAccount) {
        this.integrationAccount = integrationAccount;
        return this;
    }

    /**
     * Get the integrationServiceEnvironment property: The integration service environment.
     * 
     * @return the integrationServiceEnvironment value.
     */
    public ResourceReference integrationServiceEnvironment() {
        return this.integrationServiceEnvironment;
    }

    /**
     * Set the integrationServiceEnvironment property: The integration service environment.
     * 
     * @param integrationServiceEnvironment the integrationServiceEnvironment value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withIntegrationServiceEnvironment(ResourceReference integrationServiceEnvironment) {
        this.integrationServiceEnvironment = integrationServiceEnvironment;
        return this;
    }

    /**
     * Get the definition property: The definition.
     * 
     * @return the definition value.
     */
    public Object definition() {
        return this.definition;
    }

    /**
     * Set the definition property: The definition.
     * 
     * @param definition the definition value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withDefinition(Object definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Get the parameters property: The parameters.
     * 
     * @return the parameters value.
     */
    public Map<String, WorkflowParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withParameters(Map<String, WorkflowParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the kind property: The workflow kind.
     * 
     * @return the kind value.
     */
    public Kind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The workflow kind.
     * 
     * @param kind the kind value to set.
     * @return the WorkflowProperties object itself.
     */
    public WorkflowProperties withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointsConfiguration() != null) {
            endpointsConfiguration().validate();
        }
        if (accessControl() != null) {
            accessControl().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (integrationAccount() != null) {
            integrationAccount().validate();
        }
        if (integrationServiceEnvironment() != null) {
            integrationServiceEnvironment().validate();
        }
        if (parameters() != null) {
            parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("endpointsConfiguration", this.endpointsConfiguration);
        jsonWriter.writeJsonField("accessControl", this.accessControl);
        jsonWriter.writeJsonField("integrationAccount", this.integrationAccount);
        jsonWriter.writeJsonField("integrationServiceEnvironment", this.integrationServiceEnvironment);
        if (this.definition != null) {
            jsonWriter.writeUntypedField("definition", this.definition);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowProperties.
     */
    public static WorkflowProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowProperties deserializedWorkflowProperties = new WorkflowProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkflowProperties.provisioningState
                        = WorkflowProvisioningState.fromString(reader.getString());
                } else if ("createdTime".equals(fieldName)) {
                    deserializedWorkflowProperties.createdTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("changedTime".equals(fieldName)) {
                    deserializedWorkflowProperties.changedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("state".equals(fieldName)) {
                    deserializedWorkflowProperties.state = WorkflowState.fromString(reader.getString());
                } else if ("version".equals(fieldName)) {
                    deserializedWorkflowProperties.version = reader.getString();
                } else if ("accessEndpoint".equals(fieldName)) {
                    deserializedWorkflowProperties.accessEndpoint = reader.getString();
                } else if ("endpointsConfiguration".equals(fieldName)) {
                    deserializedWorkflowProperties.endpointsConfiguration = FlowEndpointsConfiguration.fromJson(reader);
                } else if ("accessControl".equals(fieldName)) {
                    deserializedWorkflowProperties.accessControl = FlowAccessControlConfiguration.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedWorkflowProperties.sku = WorkflowSku.fromJson(reader);
                } else if ("integrationAccount".equals(fieldName)) {
                    deserializedWorkflowProperties.integrationAccount = ResourceReference.fromJson(reader);
                } else if ("integrationServiceEnvironment".equals(fieldName)) {
                    deserializedWorkflowProperties.integrationServiceEnvironment = ResourceReference.fromJson(reader);
                } else if ("definition".equals(fieldName)) {
                    deserializedWorkflowProperties.definition = reader.readUntyped();
                } else if ("parameters".equals(fieldName)) {
                    Map<String, WorkflowParameter> parameters
                        = reader.readMap(reader1 -> WorkflowParameter.fromJson(reader1));
                    deserializedWorkflowProperties.parameters = parameters;
                } else if ("kind".equals(fieldName)) {
                    deserializedWorkflowProperties.kind = Kind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowProperties;
        });
    }
}
