// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ApiDefinitionInfo;
import com.azure.resourcemanager.appservice.models.ApiManagementConfig;
import com.azure.resourcemanager.appservice.models.AutoHealRules;
import com.azure.resourcemanager.appservice.models.AzureStorageInfoValue;
import com.azure.resourcemanager.appservice.models.ConnStringInfo;
import com.azure.resourcemanager.appservice.models.CorsSettings;
import com.azure.resourcemanager.appservice.models.DefaultAction;
import com.azure.resourcemanager.appservice.models.Experiments;
import com.azure.resourcemanager.appservice.models.FtpsState;
import com.azure.resourcemanager.appservice.models.HandlerMapping;
import com.azure.resourcemanager.appservice.models.IpSecurityRestriction;
import com.azure.resourcemanager.appservice.models.ManagedPipelineMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ScmType;
import com.azure.resourcemanager.appservice.models.SiteLimits;
import com.azure.resourcemanager.appservice.models.SiteLoadBalancing;
import com.azure.resourcemanager.appservice.models.SiteMachineKey;
import com.azure.resourcemanager.appservice.models.SupportedTlsVersions;
import com.azure.resourcemanager.appservice.models.TlsCipherSuites;
import com.azure.resourcemanager.appservice.models.VirtualApplication;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Configuration of an App Service app.
 */
@Fluent
public final class SiteConfigInner implements JsonSerializable<SiteConfigInner> {
    /*
     * Number of workers.
     */
    private Integer numberOfWorkers;

    /*
     * Default documents.
     */
    private List<String> defaultDocuments;

    /*
     * .NET Framework version.
     */
    private String netFrameworkVersion;

    /*
     * Version of PHP.
     */
    private String phpVersion;

    /*
     * Version of Python.
     */
    private String pythonVersion;

    /*
     * Version of Node.js.
     */
    private String nodeVersion;

    /*
     * Version of PowerShell.
     */
    private String powerShellVersion;

    /*
     * Linux App Framework and version
     */
    private String linuxFxVersion;

    /*
     * Xenon App Framework and version
     */
    private String windowsFxVersion;

    /*
     * <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
     */
    private Boolean requestTracingEnabled;

    /*
     * Request tracing expiration time.
     */
    private OffsetDateTime requestTracingExpirationTime;

    /*
     * <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
     */
    private Boolean remoteDebuggingEnabled;

    /*
     * Remote debugging version.
     */
    private String remoteDebuggingVersion;

    /*
     * <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
     */
    private Boolean httpLoggingEnabled;

    /*
     * Flag to use Managed Identity Creds for ACR pull
     */
    private Boolean acrUseManagedIdentityCreds;

    /*
     * If using user managed identity, the user managed identity ClientId
     */
    private String acrUserManagedIdentityId;

    /*
     * HTTP logs directory size limit.
     */
    private Integer logsDirectorySizeLimit;

    /*
     * <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
     */
    private Boolean detailedErrorLoggingEnabled;

    /*
     * Publishing user name.
     */
    private String publishingUsername;

    /*
     * Application settings. This property is not returned in response to normal create and read requests since it may
     * contain sensitive information.
     */
    private List<NameValuePair> appSettings;

    /*
     * Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    private List<NameValuePair> metadata;

    /*
     * Connection strings. This property is not returned in response to normal create and read requests since it may
     * contain sensitive information.
     */
    private List<ConnStringInfo> connectionStrings;

    /*
     * Site MachineKey.
     */
    private SiteMachineKey machineKey;

    /*
     * Handler mappings.
     */
    private List<HandlerMapping> handlerMappings;

    /*
     * Document root.
     */
    private String documentRoot;

    /*
     * SCM type.
     */
    private ScmType scmType;

    /*
     * <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
     */
    private Boolean use32BitWorkerProcess;

    /*
     * <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
     */
    private Boolean webSocketsEnabled;

    /*
     * <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
     */
    private Boolean alwaysOn;

    /*
     * Java version.
     */
    private String javaVersion;

    /*
     * Java container.
     */
    private String javaContainer;

    /*
     * Java container version.
     */
    private String javaContainerVersion;

    /*
     * App command line to launch.
     */
    private String appCommandLine;

    /*
     * Managed pipeline mode.
     */
    private ManagedPipelineMode managedPipelineMode;

    /*
     * Virtual applications.
     */
    private List<VirtualApplication> virtualApplications;

    /*
     * Site load balancing.
     */
    private SiteLoadBalancing loadBalancing;

    /*
     * This is work around for polymorphic types.
     */
    private Experiments experiments;

    /*
     * Site limits.
     */
    private SiteLimits limits;

    /*
     * <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
     */
    private Boolean autoHealEnabled;

    /*
     * Auto Heal rules.
     */
    private AutoHealRules autoHealRules;

    /*
     * Tracing options.
     */
    private String tracingOptions;

    /*
     * Virtual Network name.
     */
    private String vnetName;

    /*
     * Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and
     * User Defined Routes applied.
     */
    private Boolean vnetRouteAllEnabled;

    /*
     * The number of private ports assigned to this app. These will be assigned dynamically on runtime.
     */
    private Integer vnetPrivatePortsCount;

    /*
     * Cross-Origin Resource Sharing (CORS) settings.
     */
    private CorsSettings cors;

    /*
     * Push endpoint settings.
     */
    private PushSettingsInner push;

    /*
     * Information about the formal API definition for the app.
     */
    private ApiDefinitionInfo apiDefinition;

    /*
     * Azure API management settings linked to the app.
     */
    private ApiManagementConfig apiManagementConfig;

    /*
     * Auto-swap slot name.
     */
    private String autoSwapSlotName;

    /*
     * <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
     */
    private Boolean localMySqlEnabled;

    /*
     * Managed Service Identity Id
     */
    private Integer managedServiceIdentityId;

    /*
     * Explicit Managed Service Identity Id
     */
    private Integer xManagedServiceIdentityId;

    /*
     * Identity to use for Key Vault Reference authentication.
     */
    private String keyVaultReferenceIdentity;

    /*
     * IP security restrictions for main.
     */
    private List<IpSecurityRestriction> ipSecurityRestrictions;

    /*
     * Default action for main access restriction if no rules are matched.
     */
    private DefaultAction ipSecurityRestrictionsDefaultAction;

    /*
     * IP security restrictions for scm.
     */
    private List<IpSecurityRestriction> scmIpSecurityRestrictions;

    /*
     * Default action for scm access restriction if no rules are matched.
     */
    private DefaultAction scmIpSecurityRestrictionsDefaultAction;

    /*
     * IP security restrictions for scm to use main.
     */
    private Boolean scmIpSecurityRestrictionsUseMain;

    /*
     * Http20Enabled: configures a web site to allow clients to connect over http2.0
     */
    private Boolean http20Enabled;

    /*
     * Http20ProxyFlag: Configures a website to allow http2.0 to pass be proxied all the way to the app. 0 = disabled, 1
     * = pass through all http2 traffic, 2 = pass through gRPC only.
     */
    private Integer http20ProxyFlag;

    /*
     * MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    private SupportedTlsVersions minTlsVersion;

    /*
     * The minimum strength TLS cipher suite allowed for an application
     */
    private TlsCipherSuites minTlsCipherSuite;

    /*
     * ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    private SupportedTlsVersions scmMinTlsVersion;

    /*
     * State of FTP / FTPS service
     */
    private FtpsState ftpsState;

    /*
     * Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans
     */
    private Integer preWarmedInstanceCount;

    /*
     * Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans
     */
    private Integer functionAppScaleLimit;

    /*
     * Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
     */
    private Integer elasticWebAppScaleLimit;

    /*
     * Health check path
     */
    private String healthCheckPath;

    /*
     * Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     */
    private Boolean functionsRuntimeScaleMonitoringEnabled;

    /*
     * Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting
     * the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values
     * https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
     */
    private String websiteTimeZone;

    /*
     * Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans
     */
    private Integer minimumElasticInstanceCount;

    /*
     * List of Azure Storage Accounts.
     */
    private Map<String, AzureStorageInfoValue> azureStorageAccounts;

    /*
     * Property to allow or block all public traffic.
     */
    private String publicNetworkAccess;

    /**
     * Creates an instance of SiteConfigInner class.
     */
    public SiteConfigInner() {
    }

    /**
     * Get the numberOfWorkers property: Number of workers.
     * 
     * @return the numberOfWorkers value.
     */
    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    /**
     * Set the numberOfWorkers property: Number of workers.
     * 
     * @param numberOfWorkers the numberOfWorkers value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withNumberOfWorkers(Integer numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
        return this;
    }

    /**
     * Get the defaultDocuments property: Default documents.
     * 
     * @return the defaultDocuments value.
     */
    public List<String> defaultDocuments() {
        return this.defaultDocuments;
    }

    /**
     * Set the defaultDocuments property: Default documents.
     * 
     * @param defaultDocuments the defaultDocuments value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withDefaultDocuments(List<String> defaultDocuments) {
        this.defaultDocuments = defaultDocuments;
        return this;
    }

    /**
     * Get the netFrameworkVersion property: .NET Framework version.
     * 
     * @return the netFrameworkVersion value.
     */
    public String netFrameworkVersion() {
        return this.netFrameworkVersion;
    }

    /**
     * Set the netFrameworkVersion property: .NET Framework version.
     * 
     * @param netFrameworkVersion the netFrameworkVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withNetFrameworkVersion(String netFrameworkVersion) {
        this.netFrameworkVersion = netFrameworkVersion;
        return this;
    }

    /**
     * Get the phpVersion property: Version of PHP.
     * 
     * @return the phpVersion value.
     */
    public String phpVersion() {
        return this.phpVersion;
    }

    /**
     * Set the phpVersion property: Version of PHP.
     * 
     * @param phpVersion the phpVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPhpVersion(String phpVersion) {
        this.phpVersion = phpVersion;
        return this;
    }

    /**
     * Get the pythonVersion property: Version of Python.
     * 
     * @return the pythonVersion value.
     */
    public String pythonVersion() {
        return this.pythonVersion;
    }

    /**
     * Set the pythonVersion property: Version of Python.
     * 
     * @param pythonVersion the pythonVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPythonVersion(String pythonVersion) {
        this.pythonVersion = pythonVersion;
        return this;
    }

    /**
     * Get the nodeVersion property: Version of Node.js.
     * 
     * @return the nodeVersion value.
     */
    public String nodeVersion() {
        return this.nodeVersion;
    }

    /**
     * Set the nodeVersion property: Version of Node.js.
     * 
     * @param nodeVersion the nodeVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
        return this;
    }

    /**
     * Get the powerShellVersion property: Version of PowerShell.
     * 
     * @return the powerShellVersion value.
     */
    public String powerShellVersion() {
        return this.powerShellVersion;
    }

    /**
     * Set the powerShellVersion property: Version of PowerShell.
     * 
     * @param powerShellVersion the powerShellVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPowerShellVersion(String powerShellVersion) {
        this.powerShellVersion = powerShellVersion;
        return this;
    }

    /**
     * Get the linuxFxVersion property: Linux App Framework and version.
     * 
     * @return the linuxFxVersion value.
     */
    public String linuxFxVersion() {
        return this.linuxFxVersion;
    }

    /**
     * Set the linuxFxVersion property: Linux App Framework and version.
     * 
     * @param linuxFxVersion the linuxFxVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLinuxFxVersion(String linuxFxVersion) {
        this.linuxFxVersion = linuxFxVersion;
        return this;
    }

    /**
     * Get the windowsFxVersion property: Xenon App Framework and version.
     * 
     * @return the windowsFxVersion value.
     */
    public String windowsFxVersion() {
        return this.windowsFxVersion;
    }

    /**
     * Set the windowsFxVersion property: Xenon App Framework and version.
     * 
     * @param windowsFxVersion the windowsFxVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withWindowsFxVersion(String windowsFxVersion) {
        this.windowsFxVersion = windowsFxVersion;
        return this;
    }

    /**
     * Get the requestTracingEnabled property: &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the requestTracingEnabled value.
     */
    public Boolean requestTracingEnabled() {
        return this.requestTracingEnabled;
    }

    /**
     * Set the requestTracingEnabled property: &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param requestTracingEnabled the requestTracingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRequestTracingEnabled(Boolean requestTracingEnabled) {
        this.requestTracingEnabled = requestTracingEnabled;
        return this;
    }

    /**
     * Get the requestTracingExpirationTime property: Request tracing expiration time.
     * 
     * @return the requestTracingExpirationTime value.
     */
    public OffsetDateTime requestTracingExpirationTime() {
        return this.requestTracingExpirationTime;
    }

    /**
     * Set the requestTracingExpirationTime property: Request tracing expiration time.
     * 
     * @param requestTracingExpirationTime the requestTracingExpirationTime value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRequestTracingExpirationTime(OffsetDateTime requestTracingExpirationTime) {
        this.requestTracingExpirationTime = requestTracingExpirationTime;
        return this;
    }

    /**
     * Get the remoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the remoteDebuggingEnabled value.
     */
    public Boolean remoteDebuggingEnabled() {
        return this.remoteDebuggingEnabled;
    }

    /**
     * Set the remoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param remoteDebuggingEnabled the remoteDebuggingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRemoteDebuggingEnabled(Boolean remoteDebuggingEnabled) {
        this.remoteDebuggingEnabled = remoteDebuggingEnabled;
        return this;
    }

    /**
     * Get the remoteDebuggingVersion property: Remote debugging version.
     * 
     * @return the remoteDebuggingVersion value.
     */
    public String remoteDebuggingVersion() {
        return this.remoteDebuggingVersion;
    }

    /**
     * Set the remoteDebuggingVersion property: Remote debugging version.
     * 
     * @param remoteDebuggingVersion the remoteDebuggingVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRemoteDebuggingVersion(String remoteDebuggingVersion) {
        this.remoteDebuggingVersion = remoteDebuggingVersion;
        return this;
    }

    /**
     * Get the httpLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the httpLoggingEnabled value.
     */
    public Boolean httpLoggingEnabled() {
        return this.httpLoggingEnabled;
    }

    /**
     * Set the httpLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param httpLoggingEnabled the httpLoggingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHttpLoggingEnabled(Boolean httpLoggingEnabled) {
        this.httpLoggingEnabled = httpLoggingEnabled;
        return this;
    }

    /**
     * Get the acrUseManagedIdentityCreds property: Flag to use Managed Identity Creds for ACR pull.
     * 
     * @return the acrUseManagedIdentityCreds value.
     */
    public Boolean acrUseManagedIdentityCreds() {
        return this.acrUseManagedIdentityCreds;
    }

    /**
     * Set the acrUseManagedIdentityCreds property: Flag to use Managed Identity Creds for ACR pull.
     * 
     * @param acrUseManagedIdentityCreds the acrUseManagedIdentityCreds value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAcrUseManagedIdentityCreds(Boolean acrUseManagedIdentityCreds) {
        this.acrUseManagedIdentityCreds = acrUseManagedIdentityCreds;
        return this;
    }

    /**
     * Get the acrUserManagedIdentityId property: If using user managed identity, the user managed identity ClientId.
     * 
     * @return the acrUserManagedIdentityId value.
     */
    public String acrUserManagedIdentityId() {
        return this.acrUserManagedIdentityId;
    }

    /**
     * Set the acrUserManagedIdentityId property: If using user managed identity, the user managed identity ClientId.
     * 
     * @param acrUserManagedIdentityId the acrUserManagedIdentityId value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAcrUserManagedIdentityId(String acrUserManagedIdentityId) {
        this.acrUserManagedIdentityId = acrUserManagedIdentityId;
        return this;
    }

    /**
     * Get the logsDirectorySizeLimit property: HTTP logs directory size limit.
     * 
     * @return the logsDirectorySizeLimit value.
     */
    public Integer logsDirectorySizeLimit() {
        return this.logsDirectorySizeLimit;
    }

    /**
     * Set the logsDirectorySizeLimit property: HTTP logs directory size limit.
     * 
     * @param logsDirectorySizeLimit the logsDirectorySizeLimit value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLogsDirectorySizeLimit(Integer logsDirectorySizeLimit) {
        this.logsDirectorySizeLimit = logsDirectorySizeLimit;
        return this;
    }

    /**
     * Get the detailedErrorLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the detailedErrorLoggingEnabled value.
     */
    public Boolean detailedErrorLoggingEnabled() {
        return this.detailedErrorLoggingEnabled;
    }

    /**
     * Set the detailedErrorLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param detailedErrorLoggingEnabled the detailedErrorLoggingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withDetailedErrorLoggingEnabled(Boolean detailedErrorLoggingEnabled) {
        this.detailedErrorLoggingEnabled = detailedErrorLoggingEnabled;
        return this;
    }

    /**
     * Get the publishingUsername property: Publishing user name.
     * 
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.publishingUsername;
    }

    /**
     * Set the publishingUsername property: Publishing user name.
     * 
     * @param publishingUsername the publishingUsername value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    /**
     * Get the appSettings property: Application settings. This property is not returned in response to normal create
     * and read requests since it may contain sensitive information.
     * 
     * @return the appSettings value.
     */
    public List<NameValuePair> appSettings() {
        return this.appSettings;
    }

    /**
     * Set the appSettings property: Application settings. This property is not returned in response to normal create
     * and read requests since it may contain sensitive information.
     * 
     * @param appSettings the appSettings value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAppSettings(List<NameValuePair> appSettings) {
        this.appSettings = appSettings;
        return this;
    }

    /**
     * Get the metadata property: Application metadata. This property cannot be retrieved, since it may contain secrets.
     * 
     * @return the metadata value.
     */
    public List<NameValuePair> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Application metadata. This property cannot be retrieved, since it may contain secrets.
     * 
     * @param metadata the metadata value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withMetadata(List<NameValuePair> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the connectionStrings property: Connection strings. This property is not returned in response to normal
     * create and read requests since it may contain sensitive information.
     * 
     * @return the connectionStrings value.
     */
    public List<ConnStringInfo> connectionStrings() {
        return this.connectionStrings;
    }

    /**
     * Set the connectionStrings property: Connection strings. This property is not returned in response to normal
     * create and read requests since it may contain sensitive information.
     * 
     * @param connectionStrings the connectionStrings value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withConnectionStrings(List<ConnStringInfo> connectionStrings) {
        this.connectionStrings = connectionStrings;
        return this;
    }

    /**
     * Get the machineKey property: Site MachineKey.
     * 
     * @return the machineKey value.
     */
    public SiteMachineKey machineKey() {
        return this.machineKey;
    }

    /**
     * Get the handlerMappings property: Handler mappings.
     * 
     * @return the handlerMappings value.
     */
    public List<HandlerMapping> handlerMappings() {
        return this.handlerMappings;
    }

    /**
     * Set the handlerMappings property: Handler mappings.
     * 
     * @param handlerMappings the handlerMappings value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHandlerMappings(List<HandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
        return this;
    }

    /**
     * Get the documentRoot property: Document root.
     * 
     * @return the documentRoot value.
     */
    public String documentRoot() {
        return this.documentRoot;
    }

    /**
     * Set the documentRoot property: Document root.
     * 
     * @param documentRoot the documentRoot value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withDocumentRoot(String documentRoot) {
        this.documentRoot = documentRoot;
        return this;
    }

    /**
     * Get the scmType property: SCM type.
     * 
     * @return the scmType value.
     */
    public ScmType scmType() {
        return this.scmType;
    }

    /**
     * Set the scmType property: SCM type.
     * 
     * @param scmType the scmType value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmType(ScmType scmType) {
        this.scmType = scmType;
        return this;
    }

    /**
     * Get the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the use32BitWorkerProcess value.
     */
    public Boolean use32BitWorkerProcess() {
        return this.use32BitWorkerProcess;
    }

    /**
     * Set the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param use32BitWorkerProcess the use32BitWorkerProcess value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withUse32BitWorkerProcess(Boolean use32BitWorkerProcess) {
        this.use32BitWorkerProcess = use32BitWorkerProcess;
        return this;
    }

    /**
     * Get the webSocketsEnabled property: &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the webSocketsEnabled value.
     */
    public Boolean webSocketsEnabled() {
        return this.webSocketsEnabled;
    }

    /**
     * Set the webSocketsEnabled property: &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param webSocketsEnabled the webSocketsEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withWebSocketsEnabled(Boolean webSocketsEnabled) {
        this.webSocketsEnabled = webSocketsEnabled;
        return this;
    }

    /**
     * Get the alwaysOn property: &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the alwaysOn value.
     */
    public Boolean alwaysOn() {
        return this.alwaysOn;
    }

    /**
     * Set the alwaysOn property: &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param alwaysOn the alwaysOn value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAlwaysOn(Boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
        return this;
    }

    /**
     * Get the javaVersion property: Java version.
     * 
     * @return the javaVersion value.
     */
    public String javaVersion() {
        return this.javaVersion;
    }

    /**
     * Set the javaVersion property: Java version.
     * 
     * @param javaVersion the javaVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    /**
     * Get the javaContainer property: Java container.
     * 
     * @return the javaContainer value.
     */
    public String javaContainer() {
        return this.javaContainer;
    }

    /**
     * Set the javaContainer property: Java container.
     * 
     * @param javaContainer the javaContainer value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withJavaContainer(String javaContainer) {
        this.javaContainer = javaContainer;
        return this;
    }

    /**
     * Get the javaContainerVersion property: Java container version.
     * 
     * @return the javaContainerVersion value.
     */
    public String javaContainerVersion() {
        return this.javaContainerVersion;
    }

    /**
     * Set the javaContainerVersion property: Java container version.
     * 
     * @param javaContainerVersion the javaContainerVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withJavaContainerVersion(String javaContainerVersion) {
        this.javaContainerVersion = javaContainerVersion;
        return this;
    }

    /**
     * Get the appCommandLine property: App command line to launch.
     * 
     * @return the appCommandLine value.
     */
    public String appCommandLine() {
        return this.appCommandLine;
    }

    /**
     * Set the appCommandLine property: App command line to launch.
     * 
     * @param appCommandLine the appCommandLine value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAppCommandLine(String appCommandLine) {
        this.appCommandLine = appCommandLine;
        return this;
    }

    /**
     * Get the managedPipelineMode property: Managed pipeline mode.
     * 
     * @return the managedPipelineMode value.
     */
    public ManagedPipelineMode managedPipelineMode() {
        return this.managedPipelineMode;
    }

    /**
     * Set the managedPipelineMode property: Managed pipeline mode.
     * 
     * @param managedPipelineMode the managedPipelineMode value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withManagedPipelineMode(ManagedPipelineMode managedPipelineMode) {
        this.managedPipelineMode = managedPipelineMode;
        return this;
    }

    /**
     * Get the virtualApplications property: Virtual applications.
     * 
     * @return the virtualApplications value.
     */
    public List<VirtualApplication> virtualApplications() {
        return this.virtualApplications;
    }

    /**
     * Set the virtualApplications property: Virtual applications.
     * 
     * @param virtualApplications the virtualApplications value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVirtualApplications(List<VirtualApplication> virtualApplications) {
        this.virtualApplications = virtualApplications;
        return this;
    }

    /**
     * Get the loadBalancing property: Site load balancing.
     * 
     * @return the loadBalancing value.
     */
    public SiteLoadBalancing loadBalancing() {
        return this.loadBalancing;
    }

    /**
     * Set the loadBalancing property: Site load balancing.
     * 
     * @param loadBalancing the loadBalancing value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLoadBalancing(SiteLoadBalancing loadBalancing) {
        this.loadBalancing = loadBalancing;
        return this;
    }

    /**
     * Get the experiments property: This is work around for polymorphic types.
     * 
     * @return the experiments value.
     */
    public Experiments experiments() {
        return this.experiments;
    }

    /**
     * Set the experiments property: This is work around for polymorphic types.
     * 
     * @param experiments the experiments value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withExperiments(Experiments experiments) {
        this.experiments = experiments;
        return this;
    }

    /**
     * Get the limits property: Site limits.
     * 
     * @return the limits value.
     */
    public SiteLimits limits() {
        return this.limits;
    }

    /**
     * Set the limits property: Site limits.
     * 
     * @param limits the limits value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLimits(SiteLimits limits) {
        this.limits = limits;
        return this;
    }

    /**
     * Get the autoHealEnabled property: &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the autoHealEnabled value.
     */
    public Boolean autoHealEnabled() {
        return this.autoHealEnabled;
    }

    /**
     * Set the autoHealEnabled property: &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param autoHealEnabled the autoHealEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAutoHealEnabled(Boolean autoHealEnabled) {
        this.autoHealEnabled = autoHealEnabled;
        return this;
    }

    /**
     * Get the autoHealRules property: Auto Heal rules.
     * 
     * @return the autoHealRules value.
     */
    public AutoHealRules autoHealRules() {
        return this.autoHealRules;
    }

    /**
     * Set the autoHealRules property: Auto Heal rules.
     * 
     * @param autoHealRules the autoHealRules value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAutoHealRules(AutoHealRules autoHealRules) {
        this.autoHealRules = autoHealRules;
        return this;
    }

    /**
     * Get the tracingOptions property: Tracing options.
     * 
     * @return the tracingOptions value.
     */
    public String tracingOptions() {
        return this.tracingOptions;
    }

    /**
     * Set the tracingOptions property: Tracing options.
     * 
     * @param tracingOptions the tracingOptions value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withTracingOptions(String tracingOptions) {
        this.tracingOptions = tracingOptions;
        return this;
    }

    /**
     * Get the vnetName property: Virtual Network name.
     * 
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the vnetName property: Virtual Network name.
     * 
     * @param vnetName the vnetName value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the vnetRouteAllEnabled property: Virtual Network Route All enabled. This causes all outbound traffic to have
     * Virtual Network Security Groups and User Defined Routes applied.
     * 
     * @return the vnetRouteAllEnabled value.
     */
    public Boolean vnetRouteAllEnabled() {
        return this.vnetRouteAllEnabled;
    }

    /**
     * Set the vnetRouteAllEnabled property: Virtual Network Route All enabled. This causes all outbound traffic to have
     * Virtual Network Security Groups and User Defined Routes applied.
     * 
     * @param vnetRouteAllEnabled the vnetRouteAllEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVnetRouteAllEnabled(Boolean vnetRouteAllEnabled) {
        this.vnetRouteAllEnabled = vnetRouteAllEnabled;
        return this;
    }

    /**
     * Get the vnetPrivatePortsCount property: The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     * 
     * @return the vnetPrivatePortsCount value.
     */
    public Integer vnetPrivatePortsCount() {
        return this.vnetPrivatePortsCount;
    }

    /**
     * Set the vnetPrivatePortsCount property: The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     * 
     * @param vnetPrivatePortsCount the vnetPrivatePortsCount value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVnetPrivatePortsCount(Integer vnetPrivatePortsCount) {
        this.vnetPrivatePortsCount = vnetPrivatePortsCount;
        return this;
    }

    /**
     * Get the cors property: Cross-Origin Resource Sharing (CORS) settings.
     * 
     * @return the cors value.
     */
    public CorsSettings cors() {
        return this.cors;
    }

    /**
     * Set the cors property: Cross-Origin Resource Sharing (CORS) settings.
     * 
     * @param cors the cors value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withCors(CorsSettings cors) {
        this.cors = cors;
        return this;
    }

    /**
     * Get the push property: Push endpoint settings.
     * 
     * @return the push value.
     */
    public PushSettingsInner push() {
        return this.push;
    }

    /**
     * Set the push property: Push endpoint settings.
     * 
     * @param push the push value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPush(PushSettingsInner push) {
        this.push = push;
        return this;
    }

    /**
     * Get the apiDefinition property: Information about the formal API definition for the app.
     * 
     * @return the apiDefinition value.
     */
    public ApiDefinitionInfo apiDefinition() {
        return this.apiDefinition;
    }

    /**
     * Set the apiDefinition property: Information about the formal API definition for the app.
     * 
     * @param apiDefinition the apiDefinition value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withApiDefinition(ApiDefinitionInfo apiDefinition) {
        this.apiDefinition = apiDefinition;
        return this;
    }

    /**
     * Get the apiManagementConfig property: Azure API management settings linked to the app.
     * 
     * @return the apiManagementConfig value.
     */
    public ApiManagementConfig apiManagementConfig() {
        return this.apiManagementConfig;
    }

    /**
     * Set the apiManagementConfig property: Azure API management settings linked to the app.
     * 
     * @param apiManagementConfig the apiManagementConfig value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withApiManagementConfig(ApiManagementConfig apiManagementConfig) {
        this.apiManagementConfig = apiManagementConfig;
        return this;
    }

    /**
     * Get the autoSwapSlotName property: Auto-swap slot name.
     * 
     * @return the autoSwapSlotName value.
     */
    public String autoSwapSlotName() {
        return this.autoSwapSlotName;
    }

    /**
     * Set the autoSwapSlotName property: Auto-swap slot name.
     * 
     * @param autoSwapSlotName the autoSwapSlotName value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAutoSwapSlotName(String autoSwapSlotName) {
        this.autoSwapSlotName = autoSwapSlotName;
        return this;
    }

    /**
     * Get the localMySqlEnabled property: &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the localMySqlEnabled value.
     */
    public Boolean localMySqlEnabled() {
        return this.localMySqlEnabled;
    }

    /**
     * Set the localMySqlEnabled property: &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param localMySqlEnabled the localMySqlEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLocalMySqlEnabled(Boolean localMySqlEnabled) {
        this.localMySqlEnabled = localMySqlEnabled;
        return this;
    }

    /**
     * Get the managedServiceIdentityId property: Managed Service Identity Id.
     * 
     * @return the managedServiceIdentityId value.
     */
    public Integer managedServiceIdentityId() {
        return this.managedServiceIdentityId;
    }

    /**
     * Set the managedServiceIdentityId property: Managed Service Identity Id.
     * 
     * @param managedServiceIdentityId the managedServiceIdentityId value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withManagedServiceIdentityId(Integer managedServiceIdentityId) {
        this.managedServiceIdentityId = managedServiceIdentityId;
        return this;
    }

    /**
     * Get the xManagedServiceIdentityId property: Explicit Managed Service Identity Id.
     * 
     * @return the xManagedServiceIdentityId value.
     */
    public Integer xManagedServiceIdentityId() {
        return this.xManagedServiceIdentityId;
    }

    /**
     * Set the xManagedServiceIdentityId property: Explicit Managed Service Identity Id.
     * 
     * @param xManagedServiceIdentityId the xManagedServiceIdentityId value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withXManagedServiceIdentityId(Integer xManagedServiceIdentityId) {
        this.xManagedServiceIdentityId = xManagedServiceIdentityId;
        return this;
    }

    /**
     * Get the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     * 
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    /**
     * Set the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     * 
     * @param keyVaultReferenceIdentity the keyVaultReferenceIdentity value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    /**
     * Get the ipSecurityRestrictions property: IP security restrictions for main.
     * 
     * @return the ipSecurityRestrictions value.
     */
    public List<IpSecurityRestriction> ipSecurityRestrictions() {
        return this.ipSecurityRestrictions;
    }

    /**
     * Set the ipSecurityRestrictions property: IP security restrictions for main.
     * 
     * @param ipSecurityRestrictions the ipSecurityRestrictions value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withIpSecurityRestrictions(List<IpSecurityRestriction> ipSecurityRestrictions) {
        this.ipSecurityRestrictions = ipSecurityRestrictions;
        return this;
    }

    /**
     * Get the ipSecurityRestrictionsDefaultAction property: Default action for main access restriction if no rules are
     * matched.
     * 
     * @return the ipSecurityRestrictionsDefaultAction value.
     */
    public DefaultAction ipSecurityRestrictionsDefaultAction() {
        return this.ipSecurityRestrictionsDefaultAction;
    }

    /**
     * Set the ipSecurityRestrictionsDefaultAction property: Default action for main access restriction if no rules are
     * matched.
     * 
     * @param ipSecurityRestrictionsDefaultAction the ipSecurityRestrictionsDefaultAction value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withIpSecurityRestrictionsDefaultAction(DefaultAction ipSecurityRestrictionsDefaultAction) {
        this.ipSecurityRestrictionsDefaultAction = ipSecurityRestrictionsDefaultAction;
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictions property: IP security restrictions for scm.
     * 
     * @return the scmIpSecurityRestrictions value.
     */
    public List<IpSecurityRestriction> scmIpSecurityRestrictions() {
        return this.scmIpSecurityRestrictions;
    }

    /**
     * Set the scmIpSecurityRestrictions property: IP security restrictions for scm.
     * 
     * @param scmIpSecurityRestrictions the scmIpSecurityRestrictions value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmIpSecurityRestrictions(List<IpSecurityRestriction> scmIpSecurityRestrictions) {
        this.scmIpSecurityRestrictions = scmIpSecurityRestrictions;
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictionsDefaultAction property: Default action for scm access restriction if no rules
     * are matched.
     * 
     * @return the scmIpSecurityRestrictionsDefaultAction value.
     */
    public DefaultAction scmIpSecurityRestrictionsDefaultAction() {
        return this.scmIpSecurityRestrictionsDefaultAction;
    }

    /**
     * Set the scmIpSecurityRestrictionsDefaultAction property: Default action for scm access restriction if no rules
     * are matched.
     * 
     * @param scmIpSecurityRestrictionsDefaultAction the scmIpSecurityRestrictionsDefaultAction value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner
        withScmIpSecurityRestrictionsDefaultAction(DefaultAction scmIpSecurityRestrictionsDefaultAction) {
        this.scmIpSecurityRestrictionsDefaultAction = scmIpSecurityRestrictionsDefaultAction;
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictionsUseMain property: IP security restrictions for scm to use main.
     * 
     * @return the scmIpSecurityRestrictionsUseMain value.
     */
    public Boolean scmIpSecurityRestrictionsUseMain() {
        return this.scmIpSecurityRestrictionsUseMain;
    }

    /**
     * Set the scmIpSecurityRestrictionsUseMain property: IP security restrictions for scm to use main.
     * 
     * @param scmIpSecurityRestrictionsUseMain the scmIpSecurityRestrictionsUseMain value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmIpSecurityRestrictionsUseMain(Boolean scmIpSecurityRestrictionsUseMain) {
        this.scmIpSecurityRestrictionsUseMain = scmIpSecurityRestrictionsUseMain;
        return this;
    }

    /**
     * Get the http20Enabled property: Http20Enabled: configures a web site to allow clients to connect over http2.0.
     * 
     * @return the http20Enabled value.
     */
    public Boolean http20Enabled() {
        return this.http20Enabled;
    }

    /**
     * Set the http20Enabled property: Http20Enabled: configures a web site to allow clients to connect over http2.0.
     * 
     * @param http20Enabled the http20Enabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHttp20Enabled(Boolean http20Enabled) {
        this.http20Enabled = http20Enabled;
        return this;
    }

    /**
     * Get the http20ProxyFlag property: Http20ProxyFlag: Configures a website to allow http2.0 to pass be proxied all
     * the way to the app. 0 = disabled, 1 = pass through all http2 traffic, 2 = pass through gRPC only.
     * 
     * @return the http20ProxyFlag value.
     */
    public Integer http20ProxyFlag() {
        return this.http20ProxyFlag;
    }

    /**
     * Set the http20ProxyFlag property: Http20ProxyFlag: Configures a website to allow http2.0 to pass be proxied all
     * the way to the app. 0 = disabled, 1 = pass through all http2 traffic, 2 = pass through gRPC only.
     * 
     * @param http20ProxyFlag the http20ProxyFlag value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHttp20ProxyFlag(Integer http20ProxyFlag) {
        this.http20ProxyFlag = http20ProxyFlag;
        return this;
    }

    /**
     * Get the minTlsVersion property: MinTlsVersion: configures the minimum version of TLS required for SSL requests.
     * 
     * @return the minTlsVersion value.
     */
    public SupportedTlsVersions minTlsVersion() {
        return this.minTlsVersion;
    }

    /**
     * Set the minTlsVersion property: MinTlsVersion: configures the minimum version of TLS required for SSL requests.
     * 
     * @param minTlsVersion the minTlsVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withMinTlsVersion(SupportedTlsVersions minTlsVersion) {
        this.minTlsVersion = minTlsVersion;
        return this;
    }

    /**
     * Get the minTlsCipherSuite property: The minimum strength TLS cipher suite allowed for an application.
     * 
     * @return the minTlsCipherSuite value.
     */
    public TlsCipherSuites minTlsCipherSuite() {
        return this.minTlsCipherSuite;
    }

    /**
     * Set the minTlsCipherSuite property: The minimum strength TLS cipher suite allowed for an application.
     * 
     * @param minTlsCipherSuite the minTlsCipherSuite value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withMinTlsCipherSuite(TlsCipherSuites minTlsCipherSuite) {
        this.minTlsCipherSuite = minTlsCipherSuite;
        return this;
    }

    /**
     * Get the scmMinTlsVersion property: ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site.
     * 
     * @return the scmMinTlsVersion value.
     */
    public SupportedTlsVersions scmMinTlsVersion() {
        return this.scmMinTlsVersion;
    }

    /**
     * Set the scmMinTlsVersion property: ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site.
     * 
     * @param scmMinTlsVersion the scmMinTlsVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmMinTlsVersion(SupportedTlsVersions scmMinTlsVersion) {
        this.scmMinTlsVersion = scmMinTlsVersion;
        return this;
    }

    /**
     * Get the ftpsState property: State of FTP / FTPS service.
     * 
     * @return the ftpsState value.
     */
    public FtpsState ftpsState() {
        return this.ftpsState;
    }

    /**
     * Set the ftpsState property: State of FTP / FTPS service.
     * 
     * @param ftpsState the ftpsState value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withFtpsState(FtpsState ftpsState) {
        this.ftpsState = ftpsState;
        return this;
    }

    /**
     * Get the preWarmedInstanceCount property: Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans.
     * 
     * @return the preWarmedInstanceCount value.
     */
    public Integer preWarmedInstanceCount() {
        return this.preWarmedInstanceCount;
    }

    /**
     * Set the preWarmedInstanceCount property: Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans.
     * 
     * @param preWarmedInstanceCount the preWarmedInstanceCount value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPreWarmedInstanceCount(Integer preWarmedInstanceCount) {
        this.preWarmedInstanceCount = preWarmedInstanceCount;
        return this;
    }

    /**
     * Get the functionAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans.
     * 
     * @return the functionAppScaleLimit value.
     */
    public Integer functionAppScaleLimit() {
        return this.functionAppScaleLimit;
    }

    /**
     * Set the functionAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans.
     * 
     * @param functionAppScaleLimit the functionAppScaleLimit value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withFunctionAppScaleLimit(Integer functionAppScaleLimit) {
        this.functionAppScaleLimit = functionAppScaleLimit;
        return this;
    }

    /**
     * Get the elasticWebAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the elasticWebAppScaleLimit value.
     */
    public Integer elasticWebAppScaleLimit() {
        return this.elasticWebAppScaleLimit;
    }

    /**
     * Set the elasticWebAppScaleLimit property: Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param elasticWebAppScaleLimit the elasticWebAppScaleLimit value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withElasticWebAppScaleLimit(Integer elasticWebAppScaleLimit) {
        this.elasticWebAppScaleLimit = elasticWebAppScaleLimit;
        return this;
    }

    /**
     * Get the healthCheckPath property: Health check path.
     * 
     * @return the healthCheckPath value.
     */
    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    /**
     * Set the healthCheckPath property: Health check path.
     * 
     * @param healthCheckPath the healthCheckPath value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
        return this;
    }

    /**
     * Get the functionsRuntimeScaleMonitoringEnabled property: Gets or sets a value indicating whether functions
     * runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     * 
     * @return the functionsRuntimeScaleMonitoringEnabled value.
     */
    public Boolean functionsRuntimeScaleMonitoringEnabled() {
        return this.functionsRuntimeScaleMonitoringEnabled;
    }

    /**
     * Set the functionsRuntimeScaleMonitoringEnabled property: Gets or sets a value indicating whether functions
     * runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     * 
     * @param functionsRuntimeScaleMonitoringEnabled the functionsRuntimeScaleMonitoringEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withFunctionsRuntimeScaleMonitoringEnabled(Boolean functionsRuntimeScaleMonitoringEnabled) {
        this.functionsRuntimeScaleMonitoringEnabled = functionsRuntimeScaleMonitoringEnabled;
        return this;
    }

    /**
     * Get the websiteTimeZone property: Sets the time zone a site uses for generating timestamps. Compatible with Linux
     * and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux,
     * expects tz database values https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * 
     * @return the websiteTimeZone value.
     */
    public String websiteTimeZone() {
        return this.websiteTimeZone;
    }

    /**
     * Set the websiteTimeZone property: Sets the time zone a site uses for generating timestamps. Compatible with Linux
     * and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux,
     * expects tz database values https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * 
     * @param websiteTimeZone the websiteTimeZone value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withWebsiteTimeZone(String websiteTimeZone) {
        this.websiteTimeZone = websiteTimeZone;
        return this;
    }

    /**
     * Get the minimumElasticInstanceCount property: Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans.
     * 
     * @return the minimumElasticInstanceCount value.
     */
    public Integer minimumElasticInstanceCount() {
        return this.minimumElasticInstanceCount;
    }

    /**
     * Set the minimumElasticInstanceCount property: Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans.
     * 
     * @param minimumElasticInstanceCount the minimumElasticInstanceCount value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withMinimumElasticInstanceCount(Integer minimumElasticInstanceCount) {
        this.minimumElasticInstanceCount = minimumElasticInstanceCount;
        return this;
    }

    /**
     * Get the azureStorageAccounts property: List of Azure Storage Accounts.
     * 
     * @return the azureStorageAccounts value.
     */
    public Map<String, AzureStorageInfoValue> azureStorageAccounts() {
        return this.azureStorageAccounts;
    }

    /**
     * Set the azureStorageAccounts property: List of Azure Storage Accounts.
     * 
     * @param azureStorageAccounts the azureStorageAccounts value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAzureStorageAccounts(Map<String, AzureStorageInfoValue> azureStorageAccounts) {
        this.azureStorageAccounts = azureStorageAccounts;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Property to allow or block all public traffic.
     * 
     * @return the publicNetworkAccess value.
     */
    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Property to allow or block all public traffic.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appSettings() != null) {
            appSettings().forEach(e -> e.validate());
        }
        if (metadata() != null) {
            metadata().forEach(e -> e.validate());
        }
        if (connectionStrings() != null) {
            connectionStrings().forEach(e -> e.validate());
        }
        if (machineKey() != null) {
            machineKey().validate();
        }
        if (handlerMappings() != null) {
            handlerMappings().forEach(e -> e.validate());
        }
        if (virtualApplications() != null) {
            virtualApplications().forEach(e -> e.validate());
        }
        if (experiments() != null) {
            experiments().validate();
        }
        if (limits() != null) {
            limits().validate();
        }
        if (autoHealRules() != null) {
            autoHealRules().validate();
        }
        if (cors() != null) {
            cors().validate();
        }
        if (push() != null) {
            push().validate();
        }
        if (apiDefinition() != null) {
            apiDefinition().validate();
        }
        if (apiManagementConfig() != null) {
            apiManagementConfig().validate();
        }
        if (ipSecurityRestrictions() != null) {
            ipSecurityRestrictions().forEach(e -> e.validate());
        }
        if (scmIpSecurityRestrictions() != null) {
            scmIpSecurityRestrictions().forEach(e -> e.validate());
        }
        if (azureStorageAccounts() != null) {
            azureStorageAccounts().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("numberOfWorkers", this.numberOfWorkers);
        jsonWriter.writeArrayField("defaultDocuments", this.defaultDocuments,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("netFrameworkVersion", this.netFrameworkVersion);
        jsonWriter.writeStringField("phpVersion", this.phpVersion);
        jsonWriter.writeStringField("pythonVersion", this.pythonVersion);
        jsonWriter.writeStringField("nodeVersion", this.nodeVersion);
        jsonWriter.writeStringField("powerShellVersion", this.powerShellVersion);
        jsonWriter.writeStringField("linuxFxVersion", this.linuxFxVersion);
        jsonWriter.writeStringField("windowsFxVersion", this.windowsFxVersion);
        jsonWriter.writeBooleanField("requestTracingEnabled", this.requestTracingEnabled);
        jsonWriter.writeStringField("requestTracingExpirationTime",
            this.requestTracingExpirationTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.requestTracingExpirationTime));
        jsonWriter.writeBooleanField("remoteDebuggingEnabled", this.remoteDebuggingEnabled);
        jsonWriter.writeStringField("remoteDebuggingVersion", this.remoteDebuggingVersion);
        jsonWriter.writeBooleanField("httpLoggingEnabled", this.httpLoggingEnabled);
        jsonWriter.writeBooleanField("acrUseManagedIdentityCreds", this.acrUseManagedIdentityCreds);
        jsonWriter.writeStringField("acrUserManagedIdentityID", this.acrUserManagedIdentityId);
        jsonWriter.writeNumberField("logsDirectorySizeLimit", this.logsDirectorySizeLimit);
        jsonWriter.writeBooleanField("detailedErrorLoggingEnabled", this.detailedErrorLoggingEnabled);
        jsonWriter.writeStringField("publishingUsername", this.publishingUsername);
        jsonWriter.writeArrayField("appSettings", this.appSettings, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("connectionStrings", this.connectionStrings,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("handlerMappings", this.handlerMappings,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("documentRoot", this.documentRoot);
        jsonWriter.writeStringField("scmType", this.scmType == null ? null : this.scmType.toString());
        jsonWriter.writeBooleanField("use32BitWorkerProcess", this.use32BitWorkerProcess);
        jsonWriter.writeBooleanField("webSocketsEnabled", this.webSocketsEnabled);
        jsonWriter.writeBooleanField("alwaysOn", this.alwaysOn);
        jsonWriter.writeStringField("javaVersion", this.javaVersion);
        jsonWriter.writeStringField("javaContainer", this.javaContainer);
        jsonWriter.writeStringField("javaContainerVersion", this.javaContainerVersion);
        jsonWriter.writeStringField("appCommandLine", this.appCommandLine);
        jsonWriter.writeStringField("managedPipelineMode",
            this.managedPipelineMode == null ? null : this.managedPipelineMode.toString());
        jsonWriter.writeArrayField("virtualApplications", this.virtualApplications,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("loadBalancing", this.loadBalancing == null ? null : this.loadBalancing.toString());
        jsonWriter.writeJsonField("experiments", this.experiments);
        jsonWriter.writeJsonField("limits", this.limits);
        jsonWriter.writeBooleanField("autoHealEnabled", this.autoHealEnabled);
        jsonWriter.writeJsonField("autoHealRules", this.autoHealRules);
        jsonWriter.writeStringField("tracingOptions", this.tracingOptions);
        jsonWriter.writeStringField("vnetName", this.vnetName);
        jsonWriter.writeBooleanField("vnetRouteAllEnabled", this.vnetRouteAllEnabled);
        jsonWriter.writeNumberField("vnetPrivatePortsCount", this.vnetPrivatePortsCount);
        jsonWriter.writeJsonField("cors", this.cors);
        jsonWriter.writeJsonField("push", this.push);
        jsonWriter.writeJsonField("apiDefinition", this.apiDefinition);
        jsonWriter.writeJsonField("apiManagementConfig", this.apiManagementConfig);
        jsonWriter.writeStringField("autoSwapSlotName", this.autoSwapSlotName);
        jsonWriter.writeBooleanField("localMySqlEnabled", this.localMySqlEnabled);
        jsonWriter.writeNumberField("managedServiceIdentityId", this.managedServiceIdentityId);
        jsonWriter.writeNumberField("xManagedServiceIdentityId", this.xManagedServiceIdentityId);
        jsonWriter.writeStringField("keyVaultReferenceIdentity", this.keyVaultReferenceIdentity);
        jsonWriter.writeArrayField("ipSecurityRestrictions", this.ipSecurityRestrictions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("ipSecurityRestrictionsDefaultAction",
            this.ipSecurityRestrictionsDefaultAction == null
                ? null
                : this.ipSecurityRestrictionsDefaultAction.toString());
        jsonWriter.writeArrayField("scmIpSecurityRestrictions", this.scmIpSecurityRestrictions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("scmIpSecurityRestrictionsDefaultAction",
            this.scmIpSecurityRestrictionsDefaultAction == null
                ? null
                : this.scmIpSecurityRestrictionsDefaultAction.toString());
        jsonWriter.writeBooleanField("scmIpSecurityRestrictionsUseMain", this.scmIpSecurityRestrictionsUseMain);
        jsonWriter.writeBooleanField("http20Enabled", this.http20Enabled);
        jsonWriter.writeNumberField("http20ProxyFlag", this.http20ProxyFlag);
        jsonWriter.writeStringField("minTlsVersion", this.minTlsVersion == null ? null : this.minTlsVersion.toString());
        jsonWriter.writeStringField("minTlsCipherSuite",
            this.minTlsCipherSuite == null ? null : this.minTlsCipherSuite.toString());
        jsonWriter.writeStringField("scmMinTlsVersion",
            this.scmMinTlsVersion == null ? null : this.scmMinTlsVersion.toString());
        jsonWriter.writeStringField("ftpsState", this.ftpsState == null ? null : this.ftpsState.toString());
        jsonWriter.writeNumberField("preWarmedInstanceCount", this.preWarmedInstanceCount);
        jsonWriter.writeNumberField("functionAppScaleLimit", this.functionAppScaleLimit);
        jsonWriter.writeNumberField("elasticWebAppScaleLimit", this.elasticWebAppScaleLimit);
        jsonWriter.writeStringField("healthCheckPath", this.healthCheckPath);
        jsonWriter.writeBooleanField("functionsRuntimeScaleMonitoringEnabled",
            this.functionsRuntimeScaleMonitoringEnabled);
        jsonWriter.writeStringField("websiteTimeZone", this.websiteTimeZone);
        jsonWriter.writeNumberField("minimumElasticInstanceCount", this.minimumElasticInstanceCount);
        jsonWriter.writeMapField("azureStorageAccounts", this.azureStorageAccounts,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteConfigInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteConfigInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteConfigInner.
     */
    public static SiteConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteConfigInner deserializedSiteConfigInner = new SiteConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("numberOfWorkers".equals(fieldName)) {
                    deserializedSiteConfigInner.numberOfWorkers = reader.getNullable(JsonReader::getInt);
                } else if ("defaultDocuments".equals(fieldName)) {
                    List<String> defaultDocuments = reader.readArray(reader1 -> reader1.getString());
                    deserializedSiteConfigInner.defaultDocuments = defaultDocuments;
                } else if ("netFrameworkVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.netFrameworkVersion = reader.getString();
                } else if ("phpVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.phpVersion = reader.getString();
                } else if ("pythonVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.pythonVersion = reader.getString();
                } else if ("nodeVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.nodeVersion = reader.getString();
                } else if ("powerShellVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.powerShellVersion = reader.getString();
                } else if ("linuxFxVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.linuxFxVersion = reader.getString();
                } else if ("windowsFxVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.windowsFxVersion = reader.getString();
                } else if ("requestTracingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.requestTracingEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("requestTracingExpirationTime".equals(fieldName)) {
                    deserializedSiteConfigInner.requestTracingExpirationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("remoteDebuggingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.remoteDebuggingEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("remoteDebuggingVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.remoteDebuggingVersion = reader.getString();
                } else if ("httpLoggingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.httpLoggingEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("acrUseManagedIdentityCreds".equals(fieldName)) {
                    deserializedSiteConfigInner.acrUseManagedIdentityCreds = reader.getNullable(JsonReader::getBoolean);
                } else if ("acrUserManagedIdentityID".equals(fieldName)) {
                    deserializedSiteConfigInner.acrUserManagedIdentityId = reader.getString();
                } else if ("logsDirectorySizeLimit".equals(fieldName)) {
                    deserializedSiteConfigInner.logsDirectorySizeLimit = reader.getNullable(JsonReader::getInt);
                } else if ("detailedErrorLoggingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.detailedErrorLoggingEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("publishingUsername".equals(fieldName)) {
                    deserializedSiteConfigInner.publishingUsername = reader.getString();
                } else if ("appSettings".equals(fieldName)) {
                    List<NameValuePair> appSettings = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    deserializedSiteConfigInner.appSettings = appSettings;
                } else if ("metadata".equals(fieldName)) {
                    List<NameValuePair> metadata = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    deserializedSiteConfigInner.metadata = metadata;
                } else if ("connectionStrings".equals(fieldName)) {
                    List<ConnStringInfo> connectionStrings
                        = reader.readArray(reader1 -> ConnStringInfo.fromJson(reader1));
                    deserializedSiteConfigInner.connectionStrings = connectionStrings;
                } else if ("machineKey".equals(fieldName)) {
                    deserializedSiteConfigInner.machineKey = SiteMachineKey.fromJson(reader);
                } else if ("handlerMappings".equals(fieldName)) {
                    List<HandlerMapping> handlerMappings
                        = reader.readArray(reader1 -> HandlerMapping.fromJson(reader1));
                    deserializedSiteConfigInner.handlerMappings = handlerMappings;
                } else if ("documentRoot".equals(fieldName)) {
                    deserializedSiteConfigInner.documentRoot = reader.getString();
                } else if ("scmType".equals(fieldName)) {
                    deserializedSiteConfigInner.scmType = ScmType.fromString(reader.getString());
                } else if ("use32BitWorkerProcess".equals(fieldName)) {
                    deserializedSiteConfigInner.use32BitWorkerProcess = reader.getNullable(JsonReader::getBoolean);
                } else if ("webSocketsEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.webSocketsEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("alwaysOn".equals(fieldName)) {
                    deserializedSiteConfigInner.alwaysOn = reader.getNullable(JsonReader::getBoolean);
                } else if ("javaVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.javaVersion = reader.getString();
                } else if ("javaContainer".equals(fieldName)) {
                    deserializedSiteConfigInner.javaContainer = reader.getString();
                } else if ("javaContainerVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.javaContainerVersion = reader.getString();
                } else if ("appCommandLine".equals(fieldName)) {
                    deserializedSiteConfigInner.appCommandLine = reader.getString();
                } else if ("managedPipelineMode".equals(fieldName)) {
                    deserializedSiteConfigInner.managedPipelineMode
                        = ManagedPipelineMode.fromString(reader.getString());
                } else if ("virtualApplications".equals(fieldName)) {
                    List<VirtualApplication> virtualApplications
                        = reader.readArray(reader1 -> VirtualApplication.fromJson(reader1));
                    deserializedSiteConfigInner.virtualApplications = virtualApplications;
                } else if ("loadBalancing".equals(fieldName)) {
                    deserializedSiteConfigInner.loadBalancing = SiteLoadBalancing.fromString(reader.getString());
                } else if ("experiments".equals(fieldName)) {
                    deserializedSiteConfigInner.experiments = Experiments.fromJson(reader);
                } else if ("limits".equals(fieldName)) {
                    deserializedSiteConfigInner.limits = SiteLimits.fromJson(reader);
                } else if ("autoHealEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.autoHealEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("autoHealRules".equals(fieldName)) {
                    deserializedSiteConfigInner.autoHealRules = AutoHealRules.fromJson(reader);
                } else if ("tracingOptions".equals(fieldName)) {
                    deserializedSiteConfigInner.tracingOptions = reader.getString();
                } else if ("vnetName".equals(fieldName)) {
                    deserializedSiteConfigInner.vnetName = reader.getString();
                } else if ("vnetRouteAllEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.vnetRouteAllEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("vnetPrivatePortsCount".equals(fieldName)) {
                    deserializedSiteConfigInner.vnetPrivatePortsCount = reader.getNullable(JsonReader::getInt);
                } else if ("cors".equals(fieldName)) {
                    deserializedSiteConfigInner.cors = CorsSettings.fromJson(reader);
                } else if ("push".equals(fieldName)) {
                    deserializedSiteConfigInner.push = PushSettingsInner.fromJson(reader);
                } else if ("apiDefinition".equals(fieldName)) {
                    deserializedSiteConfigInner.apiDefinition = ApiDefinitionInfo.fromJson(reader);
                } else if ("apiManagementConfig".equals(fieldName)) {
                    deserializedSiteConfigInner.apiManagementConfig = ApiManagementConfig.fromJson(reader);
                } else if ("autoSwapSlotName".equals(fieldName)) {
                    deserializedSiteConfigInner.autoSwapSlotName = reader.getString();
                } else if ("localMySqlEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.localMySqlEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("managedServiceIdentityId".equals(fieldName)) {
                    deserializedSiteConfigInner.managedServiceIdentityId = reader.getNullable(JsonReader::getInt);
                } else if ("xManagedServiceIdentityId".equals(fieldName)) {
                    deserializedSiteConfigInner.xManagedServiceIdentityId = reader.getNullable(JsonReader::getInt);
                } else if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedSiteConfigInner.keyVaultReferenceIdentity = reader.getString();
                } else if ("ipSecurityRestrictions".equals(fieldName)) {
                    List<IpSecurityRestriction> ipSecurityRestrictions
                        = reader.readArray(reader1 -> IpSecurityRestriction.fromJson(reader1));
                    deserializedSiteConfigInner.ipSecurityRestrictions = ipSecurityRestrictions;
                } else if ("ipSecurityRestrictionsDefaultAction".equals(fieldName)) {
                    deserializedSiteConfigInner.ipSecurityRestrictionsDefaultAction
                        = DefaultAction.fromString(reader.getString());
                } else if ("scmIpSecurityRestrictions".equals(fieldName)) {
                    List<IpSecurityRestriction> scmIpSecurityRestrictions
                        = reader.readArray(reader1 -> IpSecurityRestriction.fromJson(reader1));
                    deserializedSiteConfigInner.scmIpSecurityRestrictions = scmIpSecurityRestrictions;
                } else if ("scmIpSecurityRestrictionsDefaultAction".equals(fieldName)) {
                    deserializedSiteConfigInner.scmIpSecurityRestrictionsDefaultAction
                        = DefaultAction.fromString(reader.getString());
                } else if ("scmIpSecurityRestrictionsUseMain".equals(fieldName)) {
                    deserializedSiteConfigInner.scmIpSecurityRestrictionsUseMain
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("http20Enabled".equals(fieldName)) {
                    deserializedSiteConfigInner.http20Enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("http20ProxyFlag".equals(fieldName)) {
                    deserializedSiteConfigInner.http20ProxyFlag = reader.getNullable(JsonReader::getInt);
                } else if ("minTlsVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.minTlsVersion = SupportedTlsVersions.fromString(reader.getString());
                } else if ("minTlsCipherSuite".equals(fieldName)) {
                    deserializedSiteConfigInner.minTlsCipherSuite = TlsCipherSuites.fromString(reader.getString());
                } else if ("scmMinTlsVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.scmMinTlsVersion = SupportedTlsVersions.fromString(reader.getString());
                } else if ("ftpsState".equals(fieldName)) {
                    deserializedSiteConfigInner.ftpsState = FtpsState.fromString(reader.getString());
                } else if ("preWarmedInstanceCount".equals(fieldName)) {
                    deserializedSiteConfigInner.preWarmedInstanceCount = reader.getNullable(JsonReader::getInt);
                } else if ("functionAppScaleLimit".equals(fieldName)) {
                    deserializedSiteConfigInner.functionAppScaleLimit = reader.getNullable(JsonReader::getInt);
                } else if ("elasticWebAppScaleLimit".equals(fieldName)) {
                    deserializedSiteConfigInner.elasticWebAppScaleLimit = reader.getNullable(JsonReader::getInt);
                } else if ("healthCheckPath".equals(fieldName)) {
                    deserializedSiteConfigInner.healthCheckPath = reader.getString();
                } else if ("functionsRuntimeScaleMonitoringEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.functionsRuntimeScaleMonitoringEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("websiteTimeZone".equals(fieldName)) {
                    deserializedSiteConfigInner.websiteTimeZone = reader.getString();
                } else if ("minimumElasticInstanceCount".equals(fieldName)) {
                    deserializedSiteConfigInner.minimumElasticInstanceCount = reader.getNullable(JsonReader::getInt);
                } else if ("azureStorageAccounts".equals(fieldName)) {
                    Map<String, AzureStorageInfoValue> azureStorageAccounts
                        = reader.readMap(reader1 -> AzureStorageInfoValue.fromJson(reader1));
                    deserializedSiteConfigInner.azureStorageAccounts = azureStorageAccounts;
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSiteConfigInner.publicNetworkAccess = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteConfigInner;
        });
    }
}
