// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Server Farm RDP connection details.
 */
@Fluent
public final class ServerFarmRdpDetailsInner implements JsonSerializable<ServerFarmRdpDetailsInner> {
    /*
     * The RDP password for the server farm.
     */
    private String rdpPassword;

    /*
     * The RDP password expiry date.
     */
    private OffsetDateTime rdpPasswordExpiry;

    /**
     * Creates an instance of ServerFarmRdpDetailsInner class.
     */
    public ServerFarmRdpDetailsInner() {
    }

    /**
     * Get the rdpPassword property: The RDP password for the server farm.
     * 
     * @return the rdpPassword value.
     */
    public String rdpPassword() {
        return this.rdpPassword;
    }

    /**
     * Set the rdpPassword property: The RDP password for the server farm.
     * 
     * @param rdpPassword the rdpPassword value to set.
     * @return the ServerFarmRdpDetailsInner object itself.
     */
    public ServerFarmRdpDetailsInner withRdpPassword(String rdpPassword) {
        this.rdpPassword = rdpPassword;
        return this;
    }

    /**
     * Get the rdpPasswordExpiry property: The RDP password expiry date.
     * 
     * @return the rdpPasswordExpiry value.
     */
    public OffsetDateTime rdpPasswordExpiry() {
        return this.rdpPasswordExpiry;
    }

    /**
     * Set the rdpPasswordExpiry property: The RDP password expiry date.
     * 
     * @param rdpPasswordExpiry the rdpPasswordExpiry value to set.
     * @return the ServerFarmRdpDetailsInner object itself.
     */
    public ServerFarmRdpDetailsInner withRdpPasswordExpiry(OffsetDateTime rdpPasswordExpiry) {
        this.rdpPasswordExpiry = rdpPasswordExpiry;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("rdpPassword", this.rdpPassword);
        jsonWriter.writeStringField("rdpPasswordExpiry",
            this.rdpPasswordExpiry == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.rdpPasswordExpiry));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerFarmRdpDetailsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerFarmRdpDetailsInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerFarmRdpDetailsInner.
     */
    public static ServerFarmRdpDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerFarmRdpDetailsInner deserializedServerFarmRdpDetailsInner = new ServerFarmRdpDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rdpPassword".equals(fieldName)) {
                    deserializedServerFarmRdpDetailsInner.rdpPassword = reader.getString();
                } else if ("rdpPasswordExpiry".equals(fieldName)) {
                    deserializedServerFarmRdpDetailsInner.rdpPasswordExpiry = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerFarmRdpDetailsInner;
        });
    }
}
