// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ServerFarmInstance;
import java.io.IOException;
import java.util.List;

/**
 * Represents instance details for an app service plan.
 */
@Fluent
public final class ServerFarmInstanceDetailsInner implements JsonSerializable<ServerFarmInstanceDetailsInner> {
    /*
     * The server farm name.
     */
    private String serverFarmName;

    /*
     * The list of server farm instances.
     */
    private List<ServerFarmInstance> instances;

    /*
     * The total number of instances.
     */
    private Integer instanceCount;

    /**
     * Creates an instance of ServerFarmInstanceDetailsInner class.
     */
    public ServerFarmInstanceDetailsInner() {
    }

    /**
     * Get the serverFarmName property: The server farm name.
     * 
     * @return the serverFarmName value.
     */
    public String serverFarmName() {
        return this.serverFarmName;
    }

    /**
     * Set the serverFarmName property: The server farm name.
     * 
     * @param serverFarmName the serverFarmName value to set.
     * @return the ServerFarmInstanceDetailsInner object itself.
     */
    public ServerFarmInstanceDetailsInner withServerFarmName(String serverFarmName) {
        this.serverFarmName = serverFarmName;
        return this;
    }

    /**
     * Get the instances property: The list of server farm instances.
     * 
     * @return the instances value.
     */
    public List<ServerFarmInstance> instances() {
        return this.instances;
    }

    /**
     * Set the instances property: The list of server farm instances.
     * 
     * @param instances the instances value to set.
     * @return the ServerFarmInstanceDetailsInner object itself.
     */
    public ServerFarmInstanceDetailsInner withInstances(List<ServerFarmInstance> instances) {
        this.instances = instances;
        return this;
    }

    /**
     * Get the instanceCount property: The total number of instances.
     * 
     * @return the instanceCount value.
     */
    public Integer instanceCount() {
        return this.instanceCount;
    }

    /**
     * Set the instanceCount property: The total number of instances.
     * 
     * @param instanceCount the instanceCount value to set.
     * @return the ServerFarmInstanceDetailsInner object itself.
     */
    public ServerFarmInstanceDetailsInner withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverFarmName", this.serverFarmName);
        jsonWriter.writeArrayField("instances", this.instances, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("instanceCount", this.instanceCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerFarmInstanceDetailsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerFarmInstanceDetailsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerFarmInstanceDetailsInner.
     */
    public static ServerFarmInstanceDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerFarmInstanceDetailsInner deserializedServerFarmInstanceDetailsInner
                = new ServerFarmInstanceDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serverFarmName".equals(fieldName)) {
                    deserializedServerFarmInstanceDetailsInner.serverFarmName = reader.getString();
                } else if ("instances".equals(fieldName)) {
                    List<ServerFarmInstance> instances
                        = reader.readArray(reader1 -> ServerFarmInstance.fromJson(reader1));
                    deserializedServerFarmInstanceDetailsInner.instances = instances;
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedServerFarmInstanceDetailsInner.instanceCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerFarmInstanceDetailsInner;
        });
    }
}
