// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * App Service billing entity that contains information about meter which the Azure billing system utilizes to charge
 * users for services.
 */
@Fluent
public final class BillingMeterInner extends ProxyOnlyResource {
    /*
     * BillingMeter resource specific properties
     */
    private BillingMeterProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of BillingMeterInner class.
     */
    public BillingMeterInner() {
    }

    /**
     * Get the innerProperties property: BillingMeter resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private BillingMeterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BillingMeterInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the meterId property: Meter GUID onboarded in Commerce.
     * 
     * @return the meterId value.
     */
    public String meterId() {
        return this.innerProperties() == null ? null : this.innerProperties().meterId();
    }

    /**
     * Set the meterId property: Meter GUID onboarded in Commerce.
     * 
     * @param meterId the meterId value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withMeterId(String meterId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withMeterId(meterId);
        return this;
    }

    /**
     * Get the billingLocation property: Azure Location of billable resource.
     * 
     * @return the billingLocation value.
     */
    public String billingLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().billingLocation();
    }

    /**
     * Set the billingLocation property: Azure Location of billable resource.
     * 
     * @param billingLocation the billingLocation value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withBillingLocation(String billingLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withBillingLocation(billingLocation);
        return this;
    }

    /**
     * Get the shortName property: Short Name from App Service Azure pricing Page.
     * 
     * @return the shortName value.
     */
    public String shortName() {
        return this.innerProperties() == null ? null : this.innerProperties().shortName();
    }

    /**
     * Set the shortName property: Short Name from App Service Azure pricing Page.
     * 
     * @param shortName the shortName value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withShortName(String shortName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withShortName(shortName);
        return this;
    }

    /**
     * Get the friendlyName property: Friendly name of the meter.
     * 
     * @return the friendlyName value.
     */
    public String friendlyName() {
        return this.innerProperties() == null ? null : this.innerProperties().friendlyName();
    }

    /**
     * Set the friendlyName property: Friendly name of the meter.
     * 
     * @param friendlyName the friendlyName value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withFriendlyName(String friendlyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withFriendlyName(friendlyName);
        return this;
    }

    /**
     * Get the resourceType property: App Service ResourceType meter used for.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceType();
    }

    /**
     * Set the resourceType property: App Service ResourceType meter used for.
     * 
     * @param resourceType the resourceType value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withResourceType(String resourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withResourceType(resourceType);
        return this;
    }

    /**
     * Get the osType property: App Service OS type meter used for.
     * 
     * @return the osType value.
     */
    public String osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    /**
     * Set the osType property: App Service OS type meter used for.
     * 
     * @param osType the osType value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withOsType(String osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    /**
     * Get the multiplier property: Meter Multiplier.
     * 
     * @return the multiplier value.
     */
    public Double multiplier() {
        return this.innerProperties() == null ? null : this.innerProperties().multiplier();
    }

    /**
     * Set the multiplier property: Meter Multiplier.
     * 
     * @param multiplier the multiplier value to set.
     * @return the BillingMeterInner object itself.
     */
    public BillingMeterInner withMultiplier(Double multiplier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BillingMeterProperties();
        }
        this.innerProperties().withMultiplier(multiplier);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BillingMeterInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BillingMeterInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BillingMeterInner.
     */
    public static BillingMeterInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BillingMeterInner deserializedBillingMeterInner = new BillingMeterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBillingMeterInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBillingMeterInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBillingMeterInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedBillingMeterInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedBillingMeterInner.innerProperties = BillingMeterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBillingMeterInner;
        });
    }
}
