// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import com.azure.resourcemanager.appservice.fluent.models.CapabilityInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmUsageQuotaInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionKeyInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionLimitsInner;
import com.azure.resourcemanager.appservice.fluent.models.OperationInner;
import com.azure.resourcemanager.appservice.fluent.models.ServerFarmInstanceDetailsInner;
import com.azure.resourcemanager.appservice.fluent.models.ServerFarmRdpDetailsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetGatewayInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetInfoResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetRouteInner;
import com.azure.resourcemanager.appservice.models.AppServicePlanPatchResource;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AppServicePlansClient.
 */
public interface AppServicePlansClient extends InnerSupportsGet<AppServicePlanInner>,
    InnerSupportsListing<AppServicePlanInner>, InnerSupportsDelete<Void> {
    /**
     * Get all App Service plans for a subscription.
     * 
     * Description for Get all App Service plans for a subscription.
     * 
     * @param detailed Specify &lt;code&gt;true&lt;/code&gt; to return all App Service plan properties. The default is
     * &lt;code&gt;false&lt;/code&gt;, which returns a subset of the properties.
     * Retrieval of all properties may increase the API latency.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AppServicePlanInner> listAsync(Boolean detailed);

    /**
     * Get all App Service plans for a subscription.
     * 
     * Description for Get all App Service plans for a subscription.
     * 
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AppServicePlanInner> listAsync();

    /**
     * Get all App Service plans for a subscription.
     * 
     * Description for Get all App Service plans for a subscription.
     * 
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> list();

    /**
     * Get all App Service plans for a subscription.
     * 
     * Description for Get all App Service plans for a subscription.
     * 
     * @param detailed Specify &lt;code&gt;true&lt;/code&gt; to return all App Service plan properties. The default is
     * &lt;code&gt;false&lt;/code&gt;, which returns a subset of the properties.
     * Retrieval of all properties may increase the API latency.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> list(Boolean detailed, Context context);

    /**
     * Get all App Service plans in a resource group.
     * 
     * Description for Get all App Service plans in a resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AppServicePlanInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Get all App Service plans in a resource group.
     * 
     * Description for Get all App Service plans in a resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> listByResourceGroup(String resourceGroupName);

    /**
     * Get all App Service plans in a resource group.
     * 
     * Description for Get all App Service plans in a resource group.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Get an App Service plan.
     * 
     * Description for Get an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AppServicePlanInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name);

    /**
     * Get an App Service plan.
     * 
     * Description for Get an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AppServicePlanInner> getByResourceGroupAsync(String resourceGroupName, String name);

    /**
     * Get an App Service plan.
     * 
     * Description for Get an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AppServicePlanInner> getByResourceGroupWithResponse(String resourceGroupName, String name,
        Context context);

    /**
     * Get an App Service plan.
     * 
     * Description for Get an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner getByResourceGroup(String resourceGroupName, String name);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        AppServicePlanInner appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of app Service plan.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<AppServicePlanInner>, AppServicePlanInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String name, AppServicePlanInner appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of app Service plan.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AppServicePlanInner>, AppServicePlanInner> beginCreateOrUpdate(String resourceGroupName,
        String name, AppServicePlanInner appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of app Service plan.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AppServicePlanInner>, AppServicePlanInner> beginCreateOrUpdate(String resourceGroupName,
        String name, AppServicePlanInner appServicePlan, Context context);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AppServicePlanInner> createOrUpdateAsync(String resourceGroupName, String name,
        AppServicePlanInner appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner createOrUpdate(String resourceGroupName, String name, AppServicePlanInner appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner createOrUpdate(String resourceGroupName, String name, AppServicePlanInner appServicePlan,
        Context context);

    /**
     * Delete an App Service plan.
     * 
     * Description for Delete an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name);

    /**
     * Delete an App Service plan.
     * 
     * Description for Delete an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name);

    /**
     * Delete an App Service plan.
     * 
     * Description for Delete an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Delete an App Service plan.
     * 
     * Description for Delete an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AppServicePlanInner>> updateWithResponseAsync(String resourceGroupName, String name,
        AppServicePlanPatchResource appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AppServicePlanInner> updateAsync(String resourceGroupName, String name,
        AppServicePlanPatchResource appServicePlan);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AppServicePlanInner> updateWithResponse(String resourceGroupName, String name,
        AppServicePlanPatchResource appServicePlan, Context context);

    /**
     * Creates or updates an App Service Plan.
     * 
     * Description for Creates or updates an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner update(String resourceGroupName, String name, AppServicePlanPatchResource appServicePlan);

    /**
     * List all capabilities of an App Service plan.
     * 
     * Description for List all capabilities of an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<CapabilityInner>>> listCapabilitiesWithResponseAsync(String resourceGroupName, String name);

    /**
     * List all capabilities of an App Service plan.
     * 
     * Description for List all capabilities of an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<CapabilityInner>> listCapabilitiesAsync(String resourceGroupName, String name);

    /**
     * List all capabilities of an App Service plan.
     * 
     * Description for List all capabilities of an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<CapabilityInner>> listCapabilitiesWithResponse(String resourceGroupName, String name,
        Context context);

    /**
     * List all capabilities of an App Service plan.
     * 
     * Description for List all capabilities of an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<CapabilityInner> listCapabilities(String resourceGroupName, String name);

    /**
     * Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * Description for Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return server Farm RDP connection details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServerFarmRdpDetailsInner>> getServerFarmRdpPasswordWithResponseAsync(String resourceGroupName,
        String name);

    /**
     * Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * Description for Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return server Farm RDP connection details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServerFarmRdpDetailsInner> getServerFarmRdpPasswordAsync(String resourceGroupName, String name);

    /**
     * Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * Description for Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return server Farm RDP connection details along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServerFarmRdpDetailsInner> getServerFarmRdpPasswordWithResponse(String resourceGroupName, String name,
        Context context);

    /**
     * Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * Description for Get the RDP password for an IsCustomMode ServerFarm.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return server Farm RDP connection details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerFarmRdpDetailsInner getServerFarmRdpPassword(String resourceGroupName, String name);

    /**
     * Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionInner>> getHybridConnectionWithResponseAsync(String resourceGroupName, String name,
        String namespaceName, String relayName);

    /**
     * Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionInner> getHybridConnectionAsync(String resourceGroupName, String name, String namespaceName,
        String relayName);

    /**
     * Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionInner> getHybridConnectionWithResponse(String resourceGroupName, String name,
        String namespaceName, String relayName, Context context);

    /**
     * Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionInner getHybridConnection(String resourceGroupName, String name, String namespaceName,
        String relayName);

    /**
     * Delete a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteHybridConnectionWithResponseAsync(String resourceGroupName, String name,
        String namespaceName, String relayName);

    /**
     * Delete a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteHybridConnectionAsync(String resourceGroupName, String name, String namespaceName,
        String relayName);

    /**
     * Delete a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteHybridConnectionWithResponse(String resourceGroupName, String name, String namespaceName,
        String relayName, Context context);

    /**
     * Delete a Hybrid Connection in use in an App Service plan.
     * 
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Get the send key name and value of a Hybrid Connection.
     * 
     * Description for Get the send key name and value of a Hybrid Connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionKeyInner>> listHybridConnectionKeysWithResponseAsync(String resourceGroupName,
        String name, String namespaceName, String relayName);

    /**
     * Get the send key name and value of a Hybrid Connection.
     * 
     * Description for Get the send key name and value of a Hybrid Connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionKeyInner> listHybridConnectionKeysAsync(String resourceGroupName, String name,
        String namespaceName, String relayName);

    /**
     * Get the send key name and value of a Hybrid Connection.
     * 
     * Description for Get the send key name and value of a Hybrid Connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionKeyInner> listHybridConnectionKeysWithResponse(String resourceGroupName, String name,
        String namespaceName, String relayName, Context context);

    /**
     * Get the send key name and value of a Hybrid Connection.
     * 
     * Description for Get the send key name and value of a Hybrid Connection.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionKeyInner listHybridConnectionKeys(String resourceGroupName, String name, String namespaceName,
        String relayName);

    /**
     * Get all apps that use a Hybrid Connection in an App Service Plan.
     * 
     * Description for Get all apps that use a Hybrid Connection in an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Hybrid Connection namespace.
     * @param relayName Name of the Hybrid Connection relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listWebAppsByHybridConnectionAsync(String resourceGroupName, String name, String namespaceName,
        String relayName);

    /**
     * Get all apps that use a Hybrid Connection in an App Service Plan.
     * 
     * Description for Get all apps that use a Hybrid Connection in an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Hybrid Connection namespace.
     * @param relayName Name of the Hybrid Connection relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listWebAppsByHybridConnection(String resourceGroupName, String name, String namespaceName,
        String relayName);

    /**
     * Get all apps that use a Hybrid Connection in an App Service Plan.
     * 
     * Description for Get all apps that use a Hybrid Connection in an App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Hybrid Connection namespace.
     * @param relayName Name of the Hybrid Connection relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listWebAppsByHybridConnection(String resourceGroupName, String name, String namespaceName,
        String relayName, Context context);

    /**
     * Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionLimitsInner>> getHybridConnectionPlanLimitWithResponseAsync(String resourceGroupName,
        String name);

    /**
     * Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionLimitsInner> getHybridConnectionPlanLimitAsync(String resourceGroupName, String name);

    /**
     * Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionLimitsInner> getHybridConnectionPlanLimitWithResponse(String resourceGroupName,
        String name, Context context);

    /**
     * Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionLimitsInner getHybridConnectionPlanLimit(String resourceGroupName, String name);

    /**
     * Retrieve all Hybrid Connections in use in an App Service plan.
     * 
     * Description for Retrieve all Hybrid Connections in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<HybridConnectionInner> listHybridConnectionsAsync(String resourceGroupName, String name);

    /**
     * Retrieve all Hybrid Connections in use in an App Service plan.
     * 
     * Description for Retrieve all Hybrid Connections in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<HybridConnectionInner> listHybridConnections(String resourceGroupName, String name);

    /**
     * Retrieve all Hybrid Connections in use in an App Service plan.
     * 
     * Description for Retrieve all Hybrid Connections in use in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<HybridConnectionInner> listHybridConnections(String resourceGroupName, String name, Context context);

    /**
     * Get the instance details for an app service plan.
     * 
     * Description for Get the instance details for an app service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents instance details for an app service plan along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServerFarmInstanceDetailsInner>>
        getServerFarmInstanceDetailsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Get the instance details for an app service plan.
     * 
     * Description for Get the instance details for an app service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents instance details for an app service plan on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServerFarmInstanceDetailsInner> getServerFarmInstanceDetailsAsync(String resourceGroupName, String name);

    /**
     * Get the instance details for an app service plan.
     * 
     * Description for Get the instance details for an app service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents instance details for an app service plan along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServerFarmInstanceDetailsInner> getServerFarmInstanceDetailsWithResponse(String resourceGroupName,
        String name, Context context);

    /**
     * Get the instance details for an app service plan.
     * 
     * Description for Get the instance details for an app service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents instance details for an app service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerFarmInstanceDetailsInner getServerFarmInstanceDetails(String resourceGroupName, String name);

    /**
     * Restart all apps in an App Service plan.
     * 
     * Description for Restart all apps in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param softRestart Specify &lt;code&gt;true&lt;/code&gt; to perform a soft restart, applies the configuration
     * settings and restarts the apps if necessary. The default is &lt;code&gt;false&lt;/code&gt;, which always restarts
     * and reprovisions the apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> restartWebAppsWithResponseAsync(String resourceGroupName, String name, Boolean softRestart);

    /**
     * Restart all apps in an App Service plan.
     * 
     * Description for Restart all apps in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartWebAppsAsync(String resourceGroupName, String name);

    /**
     * Restart all apps in an App Service plan.
     * 
     * Description for Restart all apps in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param softRestart Specify &lt;code&gt;true&lt;/code&gt; to perform a soft restart, applies the configuration
     * settings and restarts the apps if necessary. The default is &lt;code&gt;false&lt;/code&gt;, which always restarts
     * and reprovisions the apps.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> restartWebAppsWithResponse(String resourceGroupName, String name, Boolean softRestart,
        Context context);

    /**
     * Restart all apps in an App Service plan.
     * 
     * Description for Restart all apps in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restartWebApps(String resourceGroupName, String name);

    /**
     * Get all apps associated with an App Service plan.
     * 
     * Description for Get all apps associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param skipToken Skip to a web app in the list of webapps associated with app service plan. If specified, the
     * resulting list will contain web apps starting from (including) the skipToken. Otherwise, the resulting list
     * contains web apps from the start of the list.
     * @param filter Supported filter: $filter=state eq running. Returns only web apps that are currently running.
     * @param top List page size. If specified, results are paged.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listWebAppsAsync(String resourceGroupName, String name, String skipToken, String filter,
        String top);

    /**
     * Get all apps associated with an App Service plan.
     * 
     * Description for Get all apps associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listWebAppsAsync(String resourceGroupName, String name);

    /**
     * Get all apps associated with an App Service plan.
     * 
     * Description for Get all apps associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listWebApps(String resourceGroupName, String name);

    /**
     * Get all apps associated with an App Service plan.
     * 
     * Description for Get all apps associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param skipToken Skip to a web app in the list of webapps associated with app service plan. If specified, the
     * resulting list will contain web apps starting from (including) the skipToken. Otherwise, the resulting list
     * contains web apps from the start of the list.
     * @param filter Supported filter: $filter=state eq running. Returns only web apps that are currently running.
     * @param top List page size. If specified, results are paged.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listWebApps(String resourceGroupName, String name, String skipToken, String filter,
        String top, Context context);

    /**
     * Gets all selectable SKUs for a given App Service Plan
     * 
     * Description for Gets all selectable SKUs for a given App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> getServerFarmSkusWithResponseAsync(String resourceGroupName, String name);

    /**
     * Gets all selectable SKUs for a given App Service Plan
     * 
     * Description for Gets all selectable SKUs for a given App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> getServerFarmSkusAsync(String resourceGroupName, String name);

    /**
     * Gets all selectable SKUs for a given App Service Plan
     * 
     * Description for Gets all selectable SKUs for a given App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> getServerFarmSkusWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Gets all selectable SKUs for a given App Service Plan
     * 
     * Description for Gets all selectable SKUs for a given App Service Plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object getServerFarmSkus(String resourceGroupName, String name);

    /**
     * Gets server farm usage information
     * 
     * Description for Gets server farm usage information.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
     * $filter=(name.value eq 'Metric1' or name.value eq 'Metric2').
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CsmUsageQuotaInner> listUsagesAsync(String resourceGroupName, String name, String filter);

    /**
     * Gets server farm usage information
     * 
     * Description for Gets server farm usage information.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CsmUsageQuotaInner> listUsagesAsync(String resourceGroupName, String name);

    /**
     * Gets server farm usage information
     * 
     * Description for Gets server farm usage information.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmUsageQuotaInner> listUsages(String resourceGroupName, String name);

    /**
     * Gets server farm usage information
     * 
     * Description for Gets server farm usage information.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
     * $filter=(name.value eq 'Metric1' or name.value eq 'Metric2').
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmUsageQuotaInner> listUsages(String resourceGroupName, String name, String filter, Context context);

    /**
     * Get all Virtual Networks associated with an App Service plan.
     * 
     * Description for Get all Virtual Networks associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfoResource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<VnetInfoResourceInner>>> listVnetsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Get all Virtual Networks associated with an App Service plan.
     * 
     * Description for Get all Virtual Networks associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfoResource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<VnetInfoResourceInner>> listVnetsAsync(String resourceGroupName, String name);

    /**
     * Get all Virtual Networks associated with an App Service plan.
     * 
     * Description for Get all Virtual Networks associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfoResource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<VnetInfoResourceInner>> listVnetsWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Get all Virtual Networks associated with an App Service plan.
     * 
     * Description for Get all Virtual Networks associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfoResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<VnetInfoResourceInner> listVnets(String resourceGroupName, String name);

    /**
     * Get a Virtual Network associated with an App Service plan.
     * 
     * Description for Get a Virtual Network associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetInfoResourceInner>> getVnetFromServerFarmWithResponseAsync(String resourceGroupName, String name,
        String vnetName);

    /**
     * Get a Virtual Network associated with an App Service plan.
     * 
     * Description for Get a Virtual Network associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetInfoResourceInner> getVnetFromServerFarmAsync(String resourceGroupName, String name, String vnetName);

    /**
     * Get a Virtual Network associated with an App Service plan.
     * 
     * Description for Get a Virtual Network associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetInfoResourceInner> getVnetFromServerFarmWithResponse(String resourceGroupName, String name,
        String vnetName, Context context);

    /**
     * Get a Virtual Network associated with an App Service plan.
     * 
     * Description for Get a Virtual Network associated with an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetInfoResourceInner getVnetFromServerFarm(String resourceGroupName, String name, String vnetName);

    /**
     * Get a Virtual Network gateway.
     * 
     * Description for Get a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetGatewayInner>> getVnetGatewayWithResponseAsync(String resourceGroupName, String name,
        String vnetName, String gatewayName);

    /**
     * Get a Virtual Network gateway.
     * 
     * Description for Get a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetGatewayInner> getVnetGatewayAsync(String resourceGroupName, String name, String vnetName,
        String gatewayName);

    /**
     * Get a Virtual Network gateway.
     * 
     * Description for Get a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetGatewayInner> getVnetGatewayWithResponse(String resourceGroupName, String name, String vnetName,
        String gatewayName, Context context);

    /**
     * Get a Virtual Network gateway.
     * 
     * Description for Get a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetGatewayInner getVnetGateway(String resourceGroupName, String name, String vnetName, String gatewayName);

    /**
     * Update a Virtual Network gateway.
     * 
     * Description for Update a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetGatewayInner>> updateVnetGatewayWithResponseAsync(String resourceGroupName, String name,
        String vnetName, String gatewayName, VnetGatewayInner connectionEnvelope);

    /**
     * Update a Virtual Network gateway.
     * 
     * Description for Update a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetGatewayInner> updateVnetGatewayAsync(String resourceGroupName, String name, String vnetName,
        String gatewayName, VnetGatewayInner connectionEnvelope);

    /**
     * Update a Virtual Network gateway.
     * 
     * Description for Update a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetGatewayInner> updateVnetGatewayWithResponse(String resourceGroupName, String name, String vnetName,
        String gatewayName, VnetGatewayInner connectionEnvelope, Context context);

    /**
     * Update a Virtual Network gateway.
     * 
     * Description for Update a Virtual Network gateway.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetGatewayInner updateVnetGateway(String resourceGroupName, String name, String vnetName, String gatewayName,
        VnetGatewayInner connectionEnvelope);

    /**
     * Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<VnetRouteInner>>> listRoutesForVnetWithResponseAsync(String resourceGroupName, String name,
        String vnetName);

    /**
     * Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<VnetRouteInner>> listRoutesForVnetAsync(String resourceGroupName, String name, String vnetName);

    /**
     * Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<VnetRouteInner>> listRoutesForVnetWithResponse(String resourceGroupName, String name, String vnetName,
        Context context);

    /**
     * Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<VnetRouteInner> listRoutesForVnet(String resourceGroupName, String name, String vnetName);

    /**
     * Get a Virtual Network route in an App Service plan.
     * 
     * Description for Get a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<VnetRouteInner>>> getRouteForVnetWithResponseAsync(String resourceGroupName, String name,
        String vnetName, String routeName);

    /**
     * Get a Virtual Network route in an App Service plan.
     * 
     * Description for Get a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<VnetRouteInner>> getRouteForVnetAsync(String resourceGroupName, String name, String vnetName,
        String routeName);

    /**
     * Get a Virtual Network route in an App Service plan.
     * 
     * Description for Get a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<VnetRouteInner>> getRouteForVnetWithResponse(String resourceGroupName, String name, String vnetName,
        String routeName, Context context);

    /**
     * Get a Virtual Network route in an App Service plan.
     * 
     * Description for Get a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<VnetRouteInner> getRouteForVnet(String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetRouteInner>> createOrUpdateVnetRouteWithResponseAsync(String resourceGroupName, String name,
        String vnetName, String routeName, VnetRouteInner route);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetRouteInner> createOrUpdateVnetRouteAsync(String resourceGroupName, String name, String vnetName,
        String routeName, VnetRouteInner route);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetRouteInner> createOrUpdateVnetRouteWithResponse(String resourceGroupName, String name, String vnetName,
        String routeName, VnetRouteInner route, Context context);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetRouteInner createOrUpdateVnetRoute(String resourceGroupName, String name, String vnetName, String routeName,
        VnetRouteInner route);

    /**
     * Delete a Virtual Network route in an App Service plan.
     * 
     * Description for Delete a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteVnetRouteWithResponseAsync(String resourceGroupName, String name, String vnetName,
        String routeName);

    /**
     * Delete a Virtual Network route in an App Service plan.
     * 
     * Description for Delete a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteVnetRouteAsync(String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Delete a Virtual Network route in an App Service plan.
     * 
     * Description for Delete a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteVnetRouteWithResponse(String resourceGroupName, String name, String vnetName, String routeName,
        Context context);

    /**
     * Delete a Virtual Network route in an App Service plan.
     * 
     * Description for Delete a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteVnetRoute(String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetRouteInner>> updateVnetRouteWithResponseAsync(String resourceGroupName, String name,
        String vnetName, String routeName, VnetRouteInner route);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetRouteInner> updateVnetRouteAsync(String resourceGroupName, String name, String vnetName, String routeName,
        VnetRouteInner route);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetRouteInner> updateVnetRouteWithResponse(String resourceGroupName, String name, String vnetName,
        String routeName, VnetRouteInner route, Context context);

    /**
     * Create or update a Virtual Network route in an App Service plan.
     * 
     * Description for Create or update a Virtual Network route in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server on
     * status code 400, 404.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetRouteInner updateVnetRoute(String resourceGroupName, String name, String vnetName, String routeName,
        VnetRouteInner route);

    /**
     * Reboot a worker machine in an App Service plan.
     * 
     * Description for Reboot a worker machine in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> rebootWorkerWithResponseAsync(String resourceGroupName, String name, String workerName);

    /**
     * Reboot a worker machine in an App Service plan.
     * 
     * Description for Reboot a worker machine in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> rebootWorkerAsync(String resourceGroupName, String name, String workerName);

    /**
     * Reboot a worker machine in an App Service plan.
     * 
     * Description for Reboot a worker machine in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> rebootWorkerWithResponse(String resourceGroupName, String name, String workerName, Context context);

    /**
     * Reboot a worker machine in an App Service plan.
     * 
     * Description for Reboot a worker machine in an App Service plan.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void rebootWorker(String resourceGroupName, String name, String workerName);

    /**
     * Recycles a managed instance worker machine.
     * 
     * Description for Recycles a managed instance worker machine.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<OperationInner>> recycleManagedInstanceWorkerWithResponseAsync(String resourceGroupName, String name,
        String workerName);

    /**
     * Recycles a managed instance worker machine.
     * 
     * Description for Recycles a managed instance worker machine.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<OperationInner> recycleManagedInstanceWorkerAsync(String resourceGroupName, String name, String workerName);

    /**
     * Recycles a managed instance worker machine.
     * 
     * Description for Recycles a managed instance worker machine.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<OperationInner> recycleManagedInstanceWorkerWithResponse(String resourceGroupName, String name,
        String workerName, Context context);

    /**
     * Recycles a managed instance worker machine.
     * 
     * Description for Recycles a managed instance worker machine.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    OperationInner recycleManagedInstanceWorker(String resourceGroupName, String name, String workerName);
}
