// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration section for the function app deployment.
 */
@Fluent
public final class FunctionsDeployment implements JsonSerializable<FunctionsDeployment> {
    /*
     * Storage for deployed package used by the function app.
     */
    private FunctionsDeploymentStorage storage;

    /**
     * Creates an instance of FunctionsDeployment class.
     */
    public FunctionsDeployment() {
    }

    /**
     * Get the storage property: Storage for deployed package used by the function app.
     * 
     * @return the storage value.
     */
    public FunctionsDeploymentStorage storage() {
        return this.storage;
    }

    /**
     * Set the storage property: Storage for deployed package used by the function app.
     * 
     * @param storage the storage value to set.
     * @return the FunctionsDeployment object itself.
     */
    public FunctionsDeployment withStorage(FunctionsDeploymentStorage storage) {
        this.storage = storage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storage() != null) {
            storage().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storage", this.storage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionsDeployment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionsDeployment if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionsDeployment.
     */
    public static FunctionsDeployment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionsDeployment deserializedFunctionsDeployment = new FunctionsDeployment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storage".equals(fieldName)) {
                    deserializedFunctionsDeployment.storage = FunctionsDeploymentStorage.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionsDeployment;
        });
    }
}
