// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about the formal API definition for the app.
 */
@Fluent
public final class ApiDefinitionInfo implements JsonSerializable<ApiDefinitionInfo> {
    /*
     * The URL of the API definition.
     */
    private String url;

    /**
     * Creates an instance of ApiDefinitionInfo class.
     */
    public ApiDefinitionInfo() {
    }

    /**
     * Get the url property: The URL of the API definition.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: The URL of the API definition.
     * 
     * @param url the url value to set.
     * @return the ApiDefinitionInfo object itself.
     */
    public ApiDefinitionInfo withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiDefinitionInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiDefinitionInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiDefinitionInfo.
     */
    public static ApiDefinitionInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiDefinitionInfo deserializedApiDefinitionInfo = new ApiDefinitionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    deserializedApiDefinitionInfo.url = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiDefinitionInfo;
        });
    }
}
