// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.TriggeredJobRun;
import java.io.IOException;
import java.util.List;

/**
 * TriggeredJobHistory resource specific properties.
 */
@Fluent
public final class TriggeredJobHistoryProperties implements JsonSerializable<TriggeredJobHistoryProperties> {
    /*
     * List of triggered web job runs.
     */
    private List<TriggeredJobRun> runs;

    /**
     * Creates an instance of TriggeredJobHistoryProperties class.
     */
    public TriggeredJobHistoryProperties() {
    }

    /**
     * Get the runs property: List of triggered web job runs.
     * 
     * @return the runs value.
     */
    public List<TriggeredJobRun> runs() {
        return this.runs;
    }

    /**
     * Set the runs property: List of triggered web job runs.
     * 
     * @param runs the runs value to set.
     * @return the TriggeredJobHistoryProperties object itself.
     */
    public TriggeredJobHistoryProperties withRuns(List<TriggeredJobRun> runs) {
        this.runs = runs;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runs() != null) {
            runs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("runs", this.runs, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TriggeredJobHistoryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TriggeredJobHistoryProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TriggeredJobHistoryProperties.
     */
    public static TriggeredJobHistoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TriggeredJobHistoryProperties deserializedTriggeredJobHistoryProperties
                = new TriggeredJobHistoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("runs".equals(fieldName)) {
                    List<TriggeredJobRun> runs = reader.readArray(reader1 -> TriggeredJobRun.fromJson(reader1));
                    deserializedTriggeredJobHistoryProperties.runs = runs;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTriggeredJobHistoryProperties;
        });
    }
}
