// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

/**
 * String list resource.
 */
@Fluent
public final class StringListInner extends ProxyOnlyResource {
    /*
     * List of string resources.
     */
    private List<String> properties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StringListInner class.
     */
    public StringListInner() {
    }

    /**
     * Get the properties property: List of string resources.
     * 
     * @return the properties value.
     */
    public List<String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: List of string resources.
     * 
     * @param properties the properties value to set.
     * @return the StringListInner object itself.
     */
    public StringListInner withProperties(List<String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StringListInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeArrayField("properties", this.properties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StringListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StringListInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StringListInner.
     */
    public static StringListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StringListInner deserializedStringListInner = new StringListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStringListInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStringListInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStringListInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStringListInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    List<String> properties = reader.readArray(reader1 -> reader1.getString());
                    deserializedStringListInner.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStringListInner;
        });
    }
}
