// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AuthType;
import com.azure.resourcemanager.appservice.models.EnvironmentVariable;
import com.azure.resourcemanager.appservice.models.VolumeMount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * SiteContainer resource specific properties.
 */
@Fluent
public final class SiteContainerProperties implements JsonSerializable<SiteContainerProperties> {
    /*
     * Image Name
     */
    private String image;

    /*
     * Target Port
     */
    private String targetPort;

    /*
     * <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    private boolean isMain;

    /*
     * StartUp Command
     */
    private String startUpCommand;

    /*
     * Auth Type
     */
    private AuthType authType;

    /*
     * User Name
     */
    private String username;

    /*
     * Password Secret
     */
    private String passwordSecret;

    /*
     * UserManagedIdentity ClientId
     */
    private String userManagedIdentityClientId;

    /*
     * Created Time
     */
    private OffsetDateTime createdTime;

    /*
     * Last Modified Time
     */
    private OffsetDateTime lastModifiedTime;

    /*
     * List of volume mounts
     */
    private List<VolumeMount> volumeMounts;

    /*
     * <code>true</code> if all AppSettings and ConnectionStrings have to be passed to the container as environment
     * variables; <code>false</code> otherwise.
     */
    private Boolean inheritAppSettingsAndConnectionStrings;

    /*
     * List of environment variables
     */
    private List<EnvironmentVariable> environmentVariables;

    /**
     * Creates an instance of SiteContainerProperties class.
     */
    public SiteContainerProperties() {
    }

    /**
     * Get the image property: Image Name.
     * 
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image property: Image Name.
     * 
     * @param image the image value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Get the targetPort property: Target Port.
     * 
     * @return the targetPort value.
     */
    public String targetPort() {
        return this.targetPort;
    }

    /**
     * Set the targetPort property: Target Port.
     * 
     * @param targetPort the targetPort value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withTargetPort(String targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    /**
     * Get the isMain property: &lt;code&gt;true&lt;/code&gt; if the container is the main site container;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     * 
     * @return the isMain value.
     */
    public boolean isMain() {
        return this.isMain;
    }

    /**
     * Set the isMain property: &lt;code&gt;true&lt;/code&gt; if the container is the main site container;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     * 
     * @param isMain the isMain value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withIsMain(boolean isMain) {
        this.isMain = isMain;
        return this;
    }

    /**
     * Get the startUpCommand property: StartUp Command.
     * 
     * @return the startUpCommand value.
     */
    public String startUpCommand() {
        return this.startUpCommand;
    }

    /**
     * Set the startUpCommand property: StartUp Command.
     * 
     * @param startUpCommand the startUpCommand value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withStartUpCommand(String startUpCommand) {
        this.startUpCommand = startUpCommand;
        return this;
    }

    /**
     * Get the authType property: Auth Type.
     * 
     * @return the authType value.
     */
    public AuthType authType() {
        return this.authType;
    }

    /**
     * Set the authType property: Auth Type.
     * 
     * @param authType the authType value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    /**
     * Get the username property: User Name.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: User Name.
     * 
     * @param username the username value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the passwordSecret property: Password Secret.
     * 
     * @return the passwordSecret value.
     */
    public String passwordSecret() {
        return this.passwordSecret;
    }

    /**
     * Set the passwordSecret property: Password Secret.
     * 
     * @param passwordSecret the passwordSecret value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withPasswordSecret(String passwordSecret) {
        this.passwordSecret = passwordSecret;
        return this;
    }

    /**
     * Get the userManagedIdentityClientId property: UserManagedIdentity ClientId.
     * 
     * @return the userManagedIdentityClientId value.
     */
    public String userManagedIdentityClientId() {
        return this.userManagedIdentityClientId;
    }

    /**
     * Set the userManagedIdentityClientId property: UserManagedIdentity ClientId.
     * 
     * @param userManagedIdentityClientId the userManagedIdentityClientId value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withUserManagedIdentityClientId(String userManagedIdentityClientId) {
        this.userManagedIdentityClientId = userManagedIdentityClientId;
        return this;
    }

    /**
     * Get the createdTime property: Created Time.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the lastModifiedTime property: Last Modified Time.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Get the volumeMounts property: List of volume mounts.
     * 
     * @return the volumeMounts value.
     */
    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    /**
     * Set the volumeMounts property: List of volume mounts.
     * 
     * @param volumeMounts the volumeMounts value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    /**
     * Get the inheritAppSettingsAndConnectionStrings property: &lt;code&gt;true&lt;/code&gt; if all AppSettings and
     * ConnectionStrings have to be passed to the container as environment variables; &lt;code&gt;false&lt;/code&gt;
     * otherwise.
     * 
     * @return the inheritAppSettingsAndConnectionStrings value.
     */
    public Boolean inheritAppSettingsAndConnectionStrings() {
        return this.inheritAppSettingsAndConnectionStrings;
    }

    /**
     * Set the inheritAppSettingsAndConnectionStrings property: &lt;code&gt;true&lt;/code&gt; if all AppSettings and
     * ConnectionStrings have to be passed to the container as environment variables; &lt;code&gt;false&lt;/code&gt;
     * otherwise.
     * 
     * @param inheritAppSettingsAndConnectionStrings the inheritAppSettingsAndConnectionStrings value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties
        withInheritAppSettingsAndConnectionStrings(Boolean inheritAppSettingsAndConnectionStrings) {
        this.inheritAppSettingsAndConnectionStrings = inheritAppSettingsAndConnectionStrings;
        return this;
    }

    /**
     * Get the environmentVariables property: List of environment variables.
     * 
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables property: List of environment variables.
     * 
     * @param environmentVariables the environmentVariables value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (image() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property image in model SiteContainerProperties"));
        }
        if (volumeMounts() != null) {
            volumeMounts().forEach(e -> e.validate());
        }
        if (environmentVariables() != null) {
            environmentVariables().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SiteContainerProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeBooleanField("isMain", this.isMain);
        jsonWriter.writeStringField("targetPort", this.targetPort);
        jsonWriter.writeStringField("startUpCommand", this.startUpCommand);
        jsonWriter.writeStringField("authType", this.authType == null ? null : this.authType.toString());
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("passwordSecret", this.passwordSecret);
        jsonWriter.writeStringField("userManagedIdentityClientId", this.userManagedIdentityClientId);
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("inheritAppSettingsAndConnectionStrings",
            this.inheritAppSettingsAndConnectionStrings);
        jsonWriter.writeArrayField("environmentVariables", this.environmentVariables,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteContainerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteContainerProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SiteContainerProperties.
     */
    public static SiteContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteContainerProperties deserializedSiteContainerProperties = new SiteContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("image".equals(fieldName)) {
                    deserializedSiteContainerProperties.image = reader.getString();
                } else if ("isMain".equals(fieldName)) {
                    deserializedSiteContainerProperties.isMain = reader.getBoolean();
                } else if ("targetPort".equals(fieldName)) {
                    deserializedSiteContainerProperties.targetPort = reader.getString();
                } else if ("startUpCommand".equals(fieldName)) {
                    deserializedSiteContainerProperties.startUpCommand = reader.getString();
                } else if ("authType".equals(fieldName)) {
                    deserializedSiteContainerProperties.authType = AuthType.fromString(reader.getString());
                } else if ("userName".equals(fieldName)) {
                    deserializedSiteContainerProperties.username = reader.getString();
                } else if ("passwordSecret".equals(fieldName)) {
                    deserializedSiteContainerProperties.passwordSecret = reader.getString();
                } else if ("userManagedIdentityClientId".equals(fieldName)) {
                    deserializedSiteContainerProperties.userManagedIdentityClientId = reader.getString();
                } else if ("createdTime".equals(fieldName)) {
                    deserializedSiteContainerProperties.createdTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSiteContainerProperties.lastModifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("volumeMounts".equals(fieldName)) {
                    List<VolumeMount> volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    deserializedSiteContainerProperties.volumeMounts = volumeMounts;
                } else if ("inheritAppSettingsAndConnectionStrings".equals(fieldName)) {
                    deserializedSiteContainerProperties.inheritAppSettingsAndConnectionStrings
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("environmentVariables".equals(fieldName)) {
                    List<EnvironmentVariable> environmentVariables
                        = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    deserializedSiteContainerProperties.environmentVariables = environmentVariables;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteContainerProperties;
        });
    }
}
