// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CsmOperationDescriptionProperties;
import com.azure.resourcemanager.appservice.models.CsmOperationDisplay;
import java.io.IOException;

/**
 * Description of an operation available for Microsoft.Web resource provider.
 */
@Fluent
public final class CsmOperationDescriptionInner implements JsonSerializable<CsmOperationDescriptionInner> {
    /*
     * The name property.
     */
    private String name;

    /*
     * The isDataAction property.
     */
    private Boolean isDataAction;

    /*
     * Meta data about operation used for display in portal.
     */
    private CsmOperationDisplay display;

    /*
     * The origin property.
     */
    private String origin;

    /*
     * Properties available for a Microsoft.Web resource provider operation.
     */
    private CsmOperationDescriptionProperties properties;

    /**
     * Creates an instance of CsmOperationDescriptionInner class.
     */
    public CsmOperationDescriptionInner() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the CsmOperationDescriptionInner object itself.
     */
    public CsmOperationDescriptionInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the isDataAction property: The isDataAction property.
     * 
     * @return the isDataAction value.
     */
    public Boolean isDataAction() {
        return this.isDataAction;
    }

    /**
     * Set the isDataAction property: The isDataAction property.
     * 
     * @param isDataAction the isDataAction value to set.
     * @return the CsmOperationDescriptionInner object itself.
     */
    public CsmOperationDescriptionInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    /**
     * Get the display property: Meta data about operation used for display in portal.
     * 
     * @return the display value.
     */
    public CsmOperationDisplay display() {
        return this.display;
    }

    /**
     * Set the display property: Meta data about operation used for display in portal.
     * 
     * @param display the display value to set.
     * @return the CsmOperationDescriptionInner object itself.
     */
    public CsmOperationDescriptionInner withDisplay(CsmOperationDisplay display) {
        this.display = display;
        return this;
    }

    /**
     * Get the origin property: The origin property.
     * 
     * @return the origin value.
     */
    public String origin() {
        return this.origin;
    }

    /**
     * Set the origin property: The origin property.
     * 
     * @param origin the origin value to set.
     * @return the CsmOperationDescriptionInner object itself.
     */
    public CsmOperationDescriptionInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    /**
     * Get the properties property: Properties available for a Microsoft.Web resource provider operation.
     * 
     * @return the properties value.
     */
    public CsmOperationDescriptionProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties available for a Microsoft.Web resource provider operation.
     * 
     * @param properties the properties value to set.
     * @return the CsmOperationDescriptionInner object itself.
     */
    public CsmOperationDescriptionInner withProperties(CsmOperationDescriptionProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (display() != null) {
            display().validate();
        }
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmOperationDescriptionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmOperationDescriptionInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CsmOperationDescriptionInner.
     */
    public static CsmOperationDescriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmOperationDescriptionInner deserializedCsmOperationDescriptionInner = new CsmOperationDescriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.name = reader.getString();
                } else if ("isDataAction".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.isDataAction = reader.getNullable(JsonReader::getBoolean);
                } else if ("display".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.display = CsmOperationDisplay.fromJson(reader);
                } else if ("origin".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.origin = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.properties
                        = CsmOperationDescriptionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmOperationDescriptionInner;
        });
    }
}
