// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.BackupSchedule;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import java.io.IOException;
import java.util.List;

/**
 * BackupRequest resource specific properties.
 */
@Fluent
public final class BackupRequestProperties implements JsonSerializable<BackupRequestProperties> {
    /*
     * Name of the backup.
     */
    private String backupName;

    /*
     * True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be
     * disabled.
     */
    private Boolean enabled;

    /*
     * SAS URL to the container.
     */
    private String storageAccountUrl;

    /*
     * Schedule for the backup if it is executed periodically.
     */
    private BackupSchedule backupSchedule;

    /*
     * Databases included in the backup.
     */
    private List<DatabaseBackupSetting> databases;

    /**
     * Creates an instance of BackupRequestProperties class.
     */
    public BackupRequestProperties() {
    }

    /**
     * Get the backupName property: Name of the backup.
     * 
     * @return the backupName value.
     */
    public String backupName() {
        return this.backupName;
    }

    /**
     * Set the backupName property: Name of the backup.
     * 
     * @param backupName the backupName value to set.
     * @return the BackupRequestProperties object itself.
     */
    public BackupRequestProperties withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    /**
     * Get the enabled property: True if the backup schedule is enabled (must be included in that case), false if the
     * backup schedule should be disabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: True if the backup schedule is enabled (must be included in that case), false if the
     * backup schedule should be disabled.
     * 
     * @param enabled the enabled value to set.
     * @return the BackupRequestProperties object itself.
     */
    public BackupRequestProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the storageAccountUrl property: SAS URL to the container.
     * 
     * @return the storageAccountUrl value.
     */
    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    /**
     * Set the storageAccountUrl property: SAS URL to the container.
     * 
     * @param storageAccountUrl the storageAccountUrl value to set.
     * @return the BackupRequestProperties object itself.
     */
    public BackupRequestProperties withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    /**
     * Get the backupSchedule property: Schedule for the backup if it is executed periodically.
     * 
     * @return the backupSchedule value.
     */
    public BackupSchedule backupSchedule() {
        return this.backupSchedule;
    }

    /**
     * Set the backupSchedule property: Schedule for the backup if it is executed periodically.
     * 
     * @param backupSchedule the backupSchedule value to set.
     * @return the BackupRequestProperties object itself.
     */
    public BackupRequestProperties withBackupSchedule(BackupSchedule backupSchedule) {
        this.backupSchedule = backupSchedule;
        return this;
    }

    /**
     * Get the databases property: Databases included in the backup.
     * 
     * @return the databases value.
     */
    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    /**
     * Set the databases property: Databases included in the backup.
     * 
     * @param databases the databases value to set.
     * @return the BackupRequestProperties object itself.
     */
    public BackupRequestProperties withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccountUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageAccountUrl in model BackupRequestProperties"));
        }
        if (backupSchedule() != null) {
            backupSchedule().validate();
        }
        if (databases() != null) {
            databases().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BackupRequestProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountUrl", this.storageAccountUrl);
        jsonWriter.writeStringField("backupName", this.backupName);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("backupSchedule", this.backupSchedule);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupRequestProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupRequestProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackupRequestProperties.
     */
    public static BackupRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupRequestProperties deserializedBackupRequestProperties = new BackupRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountUrl".equals(fieldName)) {
                    deserializedBackupRequestProperties.storageAccountUrl = reader.getString();
                } else if ("backupName".equals(fieldName)) {
                    deserializedBackupRequestProperties.backupName = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedBackupRequestProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("backupSchedule".equals(fieldName)) {
                    deserializedBackupRequestProperties.backupSchedule = BackupSchedule.fromJson(reader);
                } else if ("databases".equals(fieldName)) {
                    List<DatabaseBackupSetting> databases
                        = reader.readArray(reader1 -> DatabaseBackupSetting.fromJson(reader1));
                    deserializedBackupRequestProperties.databases = databases;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupRequestProperties;
        });
    }
}
