// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The VolumeMount model.
 */
@Fluent
public final class VolumeMount implements JsonSerializable<VolumeMount> {
    /*
     * Sub path in the volume where volume is mounted from.
     */
    private String volumeSubPath;

    /*
     * Target path on the container where volume is mounted on
     */
    private String containerMountPath;

    /*
     * Config Data to be mounted on the volume
     */
    private String data;

    /*
     * Boolean to specify if the mount is read only on the container
     */
    private Boolean readOnly;

    /**
     * Creates an instance of VolumeMount class.
     */
    public VolumeMount() {
    }

    /**
     * Get the volumeSubPath property: Sub path in the volume where volume is mounted from.
     * 
     * @return the volumeSubPath value.
     */
    public String volumeSubPath() {
        return this.volumeSubPath;
    }

    /**
     * Set the volumeSubPath property: Sub path in the volume where volume is mounted from.
     * 
     * @param volumeSubPath the volumeSubPath value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withVolumeSubPath(String volumeSubPath) {
        this.volumeSubPath = volumeSubPath;
        return this;
    }

    /**
     * Get the containerMountPath property: Target path on the container where volume is mounted on.
     * 
     * @return the containerMountPath value.
     */
    public String containerMountPath() {
        return this.containerMountPath;
    }

    /**
     * Set the containerMountPath property: Target path on the container where volume is mounted on.
     * 
     * @param containerMountPath the containerMountPath value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withContainerMountPath(String containerMountPath) {
        this.containerMountPath = containerMountPath;
        return this;
    }

    /**
     * Get the data property: Config Data to be mounted on the volume.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: Config Data to be mounted on the volume.
     * 
     * @param data the data value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the readOnly property: Boolean to specify if the mount is read only on the container.
     * 
     * @return the readOnly value.
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly property: Boolean to specify if the mount is read only on the container.
     * 
     * @param readOnly the readOnly value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (volumeSubPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property volumeSubPath in model VolumeMount"));
        }
        if (containerMountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property containerMountPath in model VolumeMount"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VolumeMount.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("volumeSubPath", this.volumeSubPath);
        jsonWriter.writeStringField("containerMountPath", this.containerMountPath);
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VolumeMount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VolumeMount if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VolumeMount.
     */
    public static VolumeMount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VolumeMount deserializedVolumeMount = new VolumeMount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("volumeSubPath".equals(fieldName)) {
                    deserializedVolumeMount.volumeSubPath = reader.getString();
                } else if ("containerMountPath".equals(fieldName)) {
                    deserializedVolumeMount.containerMountPath = reader.getString();
                } else if ("data".equals(fieldName)) {
                    deserializedVolumeMount.data = reader.getString();
                } else if ("readOnly".equals(fieldName)) {
                    deserializedVolumeMount.readOnly = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVolumeMount;
        });
    }
}
