// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information needed to create resources on an App Service Environment.
 */
@Fluent
public final class HostingEnvironmentDeploymentInfo implements JsonSerializable<HostingEnvironmentDeploymentInfo> {
    /*
     * Name of the App Service Environment.
     */
    private String name;

    /*
     * Location of the App Service Environment.
     */
    private String location;

    /**
     * Creates an instance of HostingEnvironmentDeploymentInfo class.
     */
    public HostingEnvironmentDeploymentInfo() {
    }

    /**
     * Get the name property: Name of the App Service Environment.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the App Service Environment.
     * 
     * @param name the name value to set.
     * @return the HostingEnvironmentDeploymentInfo object itself.
     */
    public HostingEnvironmentDeploymentInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the location property: Location of the App Service Environment.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Location of the App Service Environment.
     * 
     * @param location the location value to set.
     * @return the HostingEnvironmentDeploymentInfo object itself.
     */
    public HostingEnvironmentDeploymentInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostingEnvironmentDeploymentInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostingEnvironmentDeploymentInfo if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HostingEnvironmentDeploymentInfo.
     */
    public static HostingEnvironmentDeploymentInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostingEnvironmentDeploymentInfo deserializedHostingEnvironmentDeploymentInfo
                = new HostingEnvironmentDeploymentInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedHostingEnvironmentDeploymentInfo.name = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedHostingEnvironmentDeploymentInfo.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostingEnvironmentDeploymentInfo;
        });
    }
}
