// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The flow endpoints configuration.
 */
@Fluent
public final class FlowEndpoints implements JsonSerializable<FlowEndpoints> {
    /*
     * The outgoing ip address.
     */
    private List<IpAddress> outgoingIpAddresses;

    /*
     * The access endpoint ip address.
     */
    private List<IpAddress> accessEndpointIpAddresses;

    /**
     * Creates an instance of FlowEndpoints class.
     */
    public FlowEndpoints() {
    }

    /**
     * Get the outgoingIpAddresses property: The outgoing ip address.
     * 
     * @return the outgoingIpAddresses value.
     */
    public List<IpAddress> outgoingIpAddresses() {
        return this.outgoingIpAddresses;
    }

    /**
     * Set the outgoingIpAddresses property: The outgoing ip address.
     * 
     * @param outgoingIpAddresses the outgoingIpAddresses value to set.
     * @return the FlowEndpoints object itself.
     */
    public FlowEndpoints withOutgoingIpAddresses(List<IpAddress> outgoingIpAddresses) {
        this.outgoingIpAddresses = outgoingIpAddresses;
        return this;
    }

    /**
     * Get the accessEndpointIpAddresses property: The access endpoint ip address.
     * 
     * @return the accessEndpointIpAddresses value.
     */
    public List<IpAddress> accessEndpointIpAddresses() {
        return this.accessEndpointIpAddresses;
    }

    /**
     * Set the accessEndpointIpAddresses property: The access endpoint ip address.
     * 
     * @param accessEndpointIpAddresses the accessEndpointIpAddresses value to set.
     * @return the FlowEndpoints object itself.
     */
    public FlowEndpoints withAccessEndpointIpAddresses(List<IpAddress> accessEndpointIpAddresses) {
        this.accessEndpointIpAddresses = accessEndpointIpAddresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (outgoingIpAddresses() != null) {
            outgoingIpAddresses().forEach(e -> e.validate());
        }
        if (accessEndpointIpAddresses() != null) {
            accessEndpointIpAddresses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("outgoingIpAddresses", this.outgoingIpAddresses,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("accessEndpointIpAddresses", this.accessEndpointIpAddresses,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlowEndpoints from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlowEndpoints if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FlowEndpoints.
     */
    public static FlowEndpoints fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowEndpoints deserializedFlowEndpoints = new FlowEndpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("outgoingIpAddresses".equals(fieldName)) {
                    List<IpAddress> outgoingIpAddresses = reader.readArray(reader1 -> IpAddress.fromJson(reader1));
                    deserializedFlowEndpoints.outgoingIpAddresses = outgoingIpAddresses;
                } else if ("accessEndpointIpAddresses".equals(fieldName)) {
                    List<IpAddress> accessEndpointIpAddresses
                        = reader.readArray(reader1 -> IpAddress.fromJson(reader1));
                    deserializedFlowEndpoints.accessEndpointIpAddresses = accessEndpointIpAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlowEndpoints;
        });
    }
}
