// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The access control configuration.
 */
@Fluent
public final class FlowAccessControlConfiguration implements JsonSerializable<FlowAccessControlConfiguration> {
    /*
     * The access control configuration for invoking workflow triggers.
     */
    private FlowAccessControlConfigurationPolicy triggers;

    /*
     * The access control configuration for accessing workflow run contents.
     */
    private FlowAccessControlConfigurationPolicy contents;

    /*
     * The access control configuration for workflow actions.
     */
    private FlowAccessControlConfigurationPolicy actions;

    /*
     * The access control configuration for workflow management.
     */
    private FlowAccessControlConfigurationPolicy workflowManagement;

    /**
     * Creates an instance of FlowAccessControlConfiguration class.
     */
    public FlowAccessControlConfiguration() {
    }

    /**
     * Get the triggers property: The access control configuration for invoking workflow triggers.
     * 
     * @return the triggers value.
     */
    public FlowAccessControlConfigurationPolicy triggers() {
        return this.triggers;
    }

    /**
     * Set the triggers property: The access control configuration for invoking workflow triggers.
     * 
     * @param triggers the triggers value to set.
     * @return the FlowAccessControlConfiguration object itself.
     */
    public FlowAccessControlConfiguration withTriggers(FlowAccessControlConfigurationPolicy triggers) {
        this.triggers = triggers;
        return this;
    }

    /**
     * Get the contents property: The access control configuration for accessing workflow run contents.
     * 
     * @return the contents value.
     */
    public FlowAccessControlConfigurationPolicy contents() {
        return this.contents;
    }

    /**
     * Set the contents property: The access control configuration for accessing workflow run contents.
     * 
     * @param contents the contents value to set.
     * @return the FlowAccessControlConfiguration object itself.
     */
    public FlowAccessControlConfiguration withContents(FlowAccessControlConfigurationPolicy contents) {
        this.contents = contents;
        return this;
    }

    /**
     * Get the actions property: The access control configuration for workflow actions.
     * 
     * @return the actions value.
     */
    public FlowAccessControlConfigurationPolicy actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The access control configuration for workflow actions.
     * 
     * @param actions the actions value to set.
     * @return the FlowAccessControlConfiguration object itself.
     */
    public FlowAccessControlConfiguration withActions(FlowAccessControlConfigurationPolicy actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the workflowManagement property: The access control configuration for workflow management.
     * 
     * @return the workflowManagement value.
     */
    public FlowAccessControlConfigurationPolicy workflowManagement() {
        return this.workflowManagement;
    }

    /**
     * Set the workflowManagement property: The access control configuration for workflow management.
     * 
     * @param workflowManagement the workflowManagement value to set.
     * @return the FlowAccessControlConfiguration object itself.
     */
    public FlowAccessControlConfiguration
        withWorkflowManagement(FlowAccessControlConfigurationPolicy workflowManagement) {
        this.workflowManagement = workflowManagement;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (triggers() != null) {
            triggers().validate();
        }
        if (contents() != null) {
            contents().validate();
        }
        if (actions() != null) {
            actions().validate();
        }
        if (workflowManagement() != null) {
            workflowManagement().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("triggers", this.triggers);
        jsonWriter.writeJsonField("contents", this.contents);
        jsonWriter.writeJsonField("actions", this.actions);
        jsonWriter.writeJsonField("workflowManagement", this.workflowManagement);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlowAccessControlConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlowAccessControlConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FlowAccessControlConfiguration.
     */
    public static FlowAccessControlConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowAccessControlConfiguration deserializedFlowAccessControlConfiguration
                = new FlowAccessControlConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("triggers".equals(fieldName)) {
                    deserializedFlowAccessControlConfiguration.triggers
                        = FlowAccessControlConfigurationPolicy.fromJson(reader);
                } else if ("contents".equals(fieldName)) {
                    deserializedFlowAccessControlConfiguration.contents
                        = FlowAccessControlConfigurationPolicy.fromJson(reader);
                } else if ("actions".equals(fieldName)) {
                    deserializedFlowAccessControlConfiguration.actions
                        = FlowAccessControlConfigurationPolicy.fromJson(reader);
                } else if ("workflowManagement".equals(fieldName)) {
                    deserializedFlowAccessControlConfiguration.workflowManagement
                        = FlowAccessControlConfigurationPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlowAccessControlConfiguration;
        });
    }
}
