// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.VnetValidationTestFailure;
import java.io.IOException;
import java.util.List;

/**
 * VnetValidationFailureDetails resource specific properties.
 */
@Fluent
public final class VnetValidationFailureDetailsProperties
    implements JsonSerializable<VnetValidationFailureDetailsProperties> {
    /*
     * Text describing the validation outcome.
     */
    private String message;

    /*
     * A flag describing whether or not validation failed.
     */
    private Boolean failed;

    /*
     * A list of tests that failed in the validation.
     */
    private List<VnetValidationTestFailure> failedTests;

    /*
     * A list of warnings generated during validation.
     */
    private List<VnetValidationTestFailure> warnings;

    /**
     * Creates an instance of VnetValidationFailureDetailsProperties class.
     */
    public VnetValidationFailureDetailsProperties() {
    }

    /**
     * Get the message property: Text describing the validation outcome.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Text describing the validation outcome.
     * 
     * @param message the message value to set.
     * @return the VnetValidationFailureDetailsProperties object itself.
     */
    public VnetValidationFailureDetailsProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the failed property: A flag describing whether or not validation failed.
     * 
     * @return the failed value.
     */
    public Boolean failed() {
        return this.failed;
    }

    /**
     * Set the failed property: A flag describing whether or not validation failed.
     * 
     * @param failed the failed value to set.
     * @return the VnetValidationFailureDetailsProperties object itself.
     */
    public VnetValidationFailureDetailsProperties withFailed(Boolean failed) {
        this.failed = failed;
        return this;
    }

    /**
     * Get the failedTests property: A list of tests that failed in the validation.
     * 
     * @return the failedTests value.
     */
    public List<VnetValidationTestFailure> failedTests() {
        return this.failedTests;
    }

    /**
     * Set the failedTests property: A list of tests that failed in the validation.
     * 
     * @param failedTests the failedTests value to set.
     * @return the VnetValidationFailureDetailsProperties object itself.
     */
    public VnetValidationFailureDetailsProperties withFailedTests(List<VnetValidationTestFailure> failedTests) {
        this.failedTests = failedTests;
        return this;
    }

    /**
     * Get the warnings property: A list of warnings generated during validation.
     * 
     * @return the warnings value.
     */
    public List<VnetValidationTestFailure> warnings() {
        return this.warnings;
    }

    /**
     * Set the warnings property: A list of warnings generated during validation.
     * 
     * @param warnings the warnings value to set.
     * @return the VnetValidationFailureDetailsProperties object itself.
     */
    public VnetValidationFailureDetailsProperties withWarnings(List<VnetValidationTestFailure> warnings) {
        this.warnings = warnings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (failedTests() != null) {
            failedTests().forEach(e -> e.validate());
        }
        if (warnings() != null) {
            warnings().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeBooleanField("failed", this.failed);
        jsonWriter.writeArrayField("failedTests", this.failedTests, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VnetValidationFailureDetailsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VnetValidationFailureDetailsProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VnetValidationFailureDetailsProperties.
     */
    public static VnetValidationFailureDetailsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VnetValidationFailureDetailsProperties deserializedVnetValidationFailureDetailsProperties
                = new VnetValidationFailureDetailsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("message".equals(fieldName)) {
                    deserializedVnetValidationFailureDetailsProperties.message = reader.getString();
                } else if ("failed".equals(fieldName)) {
                    deserializedVnetValidationFailureDetailsProperties.failed
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("failedTests".equals(fieldName)) {
                    List<VnetValidationTestFailure> failedTests
                        = reader.readArray(reader1 -> VnetValidationTestFailure.fromJson(reader1));
                    deserializedVnetValidationFailureDetailsProperties.failedTests = failedTests;
                } else if ("warnings".equals(fieldName)) {
                    List<VnetValidationTestFailure> warnings
                        = reader.readArray(reader1 -> VnetValidationTestFailure.fromJson(reader1));
                    deserializedVnetValidationFailureDetailsProperties.warnings = warnings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVnetValidationFailureDetailsProperties;
        });
    }
}
