// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Virtual Network information contract.
 */
@Fluent
public final class VnetInfo implements JsonSerializable<VnetInfo> {
    /*
     * The Virtual Network's resource ID.
     */
    private String vnetResourceId;

    /*
     * The client certificate thumbprint.
     */
    private String certThumbprint;

    /*
     * A certificate file (.cer) blob containing the public key of the private key used to authenticate a
     * Point-To-Site VPN connection.
     */
    private String certBlob;

    /*
     * The routes that this Virtual Network connection uses.
     */
    private List<VnetRouteInner> routes;

    /*
     * <code>true</code> if a resync is required; otherwise, <code>false</code>.
     */
    private Boolean resyncRequired;

    /*
     * DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
     */
    private String dnsServers;

    /*
     * Flag that is used to denote if this is VNET injection
     */
    private Boolean isSwift;

    /**
     * Creates an instance of VnetInfo class.
     */
    public VnetInfo() {
    }

    /**
     * Get the vnetResourceId property: The Virtual Network's resource ID.
     * 
     * @return the vnetResourceId value.
     */
    public String vnetResourceId() {
        return this.vnetResourceId;
    }

    /**
     * Set the vnetResourceId property: The Virtual Network's resource ID.
     * 
     * @param vnetResourceId the vnetResourceId value to set.
     * @return the VnetInfo object itself.
     */
    public VnetInfo withVnetResourceId(String vnetResourceId) {
        this.vnetResourceId = vnetResourceId;
        return this;
    }

    /**
     * Get the certThumbprint property: The client certificate thumbprint.
     * 
     * @return the certThumbprint value.
     */
    public String certThumbprint() {
        return this.certThumbprint;
    }

    /**
     * Get the certBlob property: A certificate file (.cer) blob containing the public key of the private key used to
     * authenticate a
     * Point-To-Site VPN connection.
     * 
     * @return the certBlob value.
     */
    public String certBlob() {
        return this.certBlob;
    }

    /**
     * Set the certBlob property: A certificate file (.cer) blob containing the public key of the private key used to
     * authenticate a
     * Point-To-Site VPN connection.
     * 
     * @param certBlob the certBlob value to set.
     * @return the VnetInfo object itself.
     */
    public VnetInfo withCertBlob(String certBlob) {
        this.certBlob = certBlob;
        return this;
    }

    /**
     * Get the routes property: The routes that this Virtual Network connection uses.
     * 
     * @return the routes value.
     */
    public List<VnetRouteInner> routes() {
        return this.routes;
    }

    /**
     * Get the resyncRequired property: &lt;code&gt;true&lt;/code&gt; if a resync is required; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the resyncRequired value.
     */
    public Boolean resyncRequired() {
        return this.resyncRequired;
    }

    /**
     * Get the dnsServers property: DNS servers to be used by this Virtual Network. This should be a comma-separated
     * list of IP addresses.
     * 
     * @return the dnsServers value.
     */
    public String dnsServers() {
        return this.dnsServers;
    }

    /**
     * Set the dnsServers property: DNS servers to be used by this Virtual Network. This should be a comma-separated
     * list of IP addresses.
     * 
     * @param dnsServers the dnsServers value to set.
     * @return the VnetInfo object itself.
     */
    public VnetInfo withDnsServers(String dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    /**
     * Get the isSwift property: Flag that is used to denote if this is VNET injection.
     * 
     * @return the isSwift value.
     */
    public Boolean isSwift() {
        return this.isSwift;
    }

    /**
     * Set the isSwift property: Flag that is used to denote if this is VNET injection.
     * 
     * @param isSwift the isSwift value to set.
     * @return the VnetInfo object itself.
     */
    public VnetInfo withIsSwift(Boolean isSwift) {
        this.isSwift = isSwift;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routes() != null) {
            routes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vnetResourceId", this.vnetResourceId);
        jsonWriter.writeStringField("certBlob", this.certBlob);
        jsonWriter.writeStringField("dnsServers", this.dnsServers);
        jsonWriter.writeBooleanField("isSwift", this.isSwift);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VnetInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VnetInfo if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the VnetInfo.
     */
    public static VnetInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VnetInfo deserializedVnetInfo = new VnetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vnetResourceId".equals(fieldName)) {
                    deserializedVnetInfo.vnetResourceId = reader.getString();
                } else if ("certThumbprint".equals(fieldName)) {
                    deserializedVnetInfo.certThumbprint = reader.getString();
                } else if ("certBlob".equals(fieldName)) {
                    deserializedVnetInfo.certBlob = reader.getString();
                } else if ("routes".equals(fieldName)) {
                    List<VnetRouteInner> routes = reader.readArray(reader1 -> VnetRouteInner.fromJson(reader1));
                    deserializedVnetInfo.routes = routes;
                } else if ("resyncRequired".equals(fieldName)) {
                    deserializedVnetInfo.resyncRequired = reader.getNullable(JsonReader::getBoolean);
                } else if ("dnsServers".equals(fieldName)) {
                    deserializedVnetInfo.dnsServers = reader.getString();
                } else if ("isSwift".equals(fieldName)) {
                    deserializedVnetInfo.isSwift = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVnetInfo;
        });
    }
}
