// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SlotDifference resource specific properties.
 */
@Immutable
public final class SlotDifferenceProperties implements JsonSerializable<SlotDifferenceProperties> {
    /*
     * Level of the difference: Information, Warning or Error.
     */
    private String level;

    /*
     * The type of the setting: General, AppSetting or ConnectionString.
     */
    private String settingType;

    /*
     * Rule that describes how to process the setting difference during a slot swap.
     */
    private String diffRule;

    /*
     * Name of the setting.
     */
    private String settingName;

    /*
     * Value of the setting in the current slot.
     */
    private String valueInCurrentSlot;

    /*
     * Value of the setting in the target slot.
     */
    private String valueInTargetSlot;

    /*
     * Description of the setting difference.
     */
    private String description;

    /**
     * Creates an instance of SlotDifferenceProperties class.
     */
    public SlotDifferenceProperties() {
    }

    /**
     * Get the level property: Level of the difference: Information, Warning or Error.
     * 
     * @return the level value.
     */
    public String level() {
        return this.level;
    }

    /**
     * Get the settingType property: The type of the setting: General, AppSetting or ConnectionString.
     * 
     * @return the settingType value.
     */
    public String settingType() {
        return this.settingType;
    }

    /**
     * Get the diffRule property: Rule that describes how to process the setting difference during a slot swap.
     * 
     * @return the diffRule value.
     */
    public String diffRule() {
        return this.diffRule;
    }

    /**
     * Get the settingName property: Name of the setting.
     * 
     * @return the settingName value.
     */
    public String settingName() {
        return this.settingName;
    }

    /**
     * Get the valueInCurrentSlot property: Value of the setting in the current slot.
     * 
     * @return the valueInCurrentSlot value.
     */
    public String valueInCurrentSlot() {
        return this.valueInCurrentSlot;
    }

    /**
     * Get the valueInTargetSlot property: Value of the setting in the target slot.
     * 
     * @return the valueInTargetSlot value.
     */
    public String valueInTargetSlot() {
        return this.valueInTargetSlot;
    }

    /**
     * Get the description property: Description of the setting difference.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SlotDifferenceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SlotDifferenceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SlotDifferenceProperties.
     */
    public static SlotDifferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SlotDifferenceProperties deserializedSlotDifferenceProperties = new SlotDifferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("level".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.level = reader.getString();
                } else if ("settingType".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.settingType = reader.getString();
                } else if ("diffRule".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.diffRule = reader.getString();
                } else if ("settingName".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.settingName = reader.getString();
                } else if ("valueInCurrentSlot".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.valueInCurrentSlot = reader.getString();
                } else if ("valueInTargetSlot".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.valueInTargetSlot = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedSlotDifferenceProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSlotDifferenceProperties;
        });
    }
}
