// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AppLogsConfiguration;
import com.azure.resourcemanager.appservice.models.ArcConfiguration;
import com.azure.resourcemanager.appservice.models.ContainerAppsConfiguration;
import com.azure.resourcemanager.appservice.models.ExtendedLocation;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProvisioningState;
import java.io.IOException;
import java.util.Map;

/**
 * A Kubernetes cluster specialized for web workloads by Azure App Service.
 */
@Fluent
public final class KubeEnvironmentInner extends Resource {
    /*
     * KubeEnvironment resource specific properties
     */
    private KubeEnvironmentProperties innerProperties;

    /*
     * Extended Location.
     */
    private ExtendedLocation extendedLocation;

    /*
     * Kind of resource. If the resource is an app, you can refer to
     * https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-
     * resource-kind-reference for details supported values for kind.
     */
    private String kind;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of KubeEnvironmentInner class.
     */
    public KubeEnvironmentInner() {
    }

    /**
     * Get the innerProperties property: KubeEnvironment resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private KubeEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the extendedLocation property: Extended Location.
     * 
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: Extended Location.
     * 
     * @param extendedLocation the extendedLocation value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the kind property: Kind of resource. If the resource is an app, you can refer to
     * https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     * for details supported values for kind.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Kind of resource. If the resource is an app, you can refer to
     * https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     * for details supported values for kind.
     * 
     * @param kind the kind value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public KubeEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public KubeEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Kubernetes Environment.
     * 
     * @return the provisioningState value.
     */
    public KubeEnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deploymentErrors property: Any errors that occurred during deployment or deployment validation.
     * 
     * @return the deploymentErrors value.
     */
    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    /**
     * Get the internalLoadBalancerEnabled property: Only visible within Vnet/Subnet.
     * 
     * @return the internalLoadBalancerEnabled value.
     */
    public Boolean internalLoadBalancerEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancerEnabled();
    }

    /**
     * Set the internalLoadBalancerEnabled property: Only visible within Vnet/Subnet.
     * 
     * @param internalLoadBalancerEnabled the internalLoadBalancerEnabled value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withInternalLoadBalancerEnabled(Boolean internalLoadBalancerEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withInternalLoadBalancerEnabled(internalLoadBalancerEnabled);
        return this;
    }

    /**
     * Get the defaultDomain property: Default Domain Name for the cluster.
     * 
     * @return the defaultDomain value.
     */
    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    /**
     * Get the staticIp property: Static IP of the KubeEnvironment.
     * 
     * @return the staticIp value.
     */
    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    /**
     * Set the staticIp property: Static IP of the KubeEnvironment.
     * 
     * @param staticIp the staticIp value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    /**
     * Get the environmentType property: Type of Kubernetes Environment. Only supported for Container App Environments
     * with value as Managed.
     * 
     * @return the environmentType value.
     */
    public String environmentType() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentType();
    }

    /**
     * Set the environmentType property: Type of Kubernetes Environment. Only supported for Container App Environments
     * with value as Managed.
     * 
     * @param environmentType the environmentType value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withEnvironmentType(String environmentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withEnvironmentType(environmentType);
        return this;
    }

    /**
     * Get the arcConfiguration property: Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     * 
     * @return the arcConfiguration value.
     */
    public ArcConfiguration arcConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().arcConfiguration();
    }

    /**
     * Set the arcConfiguration property: Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     * 
     * @param arcConfiguration the arcConfiguration value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withArcConfiguration(ArcConfiguration arcConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withArcConfiguration(arcConfiguration);
        return this;
    }

    /**
     * Get the appLogsConfiguration property: Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported.
     * 
     * @return the appLogsConfiguration value.
     */
    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appLogsConfiguration();
    }

    /**
     * Set the appLogsConfiguration property: Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported.
     * 
     * @param appLogsConfiguration the appLogsConfiguration value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    /**
     * Get the containerAppsConfiguration property: Cluster configuration for Container Apps Environments to configure
     * Dapr Instrumentation Key and VNET Configuration.
     * 
     * @return the containerAppsConfiguration value.
     */
    public ContainerAppsConfiguration containerAppsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().containerAppsConfiguration();
    }

    /**
     * Set the containerAppsConfiguration property: Cluster configuration for Container Apps Environments to configure
     * Dapr Instrumentation Key and VNET Configuration.
     * 
     * @param containerAppsConfiguration the containerAppsConfiguration value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withContainerAppsConfiguration(ContainerAppsConfiguration containerAppsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withContainerAppsConfiguration(containerAppsConfiguration);
        return this;
    }

    /**
     * Get the aksResourceId property: The aksResourceID property.
     * 
     * @return the aksResourceId value.
     */
    public String aksResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().aksResourceId();
    }

    /**
     * Set the aksResourceId property: The aksResourceID property.
     * 
     * @param aksResourceId the aksResourceId value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withAksResourceId(String aksResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withAksResourceId(aksResourceId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KubeEnvironmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KubeEnvironmentInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KubeEnvironmentInner.
     */
    public static KubeEnvironmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubeEnvironmentInner deserializedKubeEnvironmentInner = new KubeEnvironmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKubeEnvironmentInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.innerProperties = KubeEnvironmentProperties.fromJson(reader);
                } else if ("extendedLocation".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.extendedLocation = ExtendedLocation.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    deserializedKubeEnvironmentInner.kind = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKubeEnvironmentInner;
        });
    }
}
