/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.UsageInner;
import java.io.IOException;
import java.util.List;

public final class UsageCollection
implements JsonSerializable<UsageCollection> {
    private List<UsageInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(UsageCollection.class);

    public List<UsageInner> value() {
        return this.value;
    }

    public UsageCollection withValue(List<UsageInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model UsageCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UsageCollection fromJson(JsonReader jsonReader) throws IOException {
        return (UsageCollection)jsonReader.readObject(reader -> {
            UsageCollection deserializedUsageCollection = new UsageCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedUsageCollection.value = value = reader.readArray(reader1 -> UsageInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedUsageCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageCollection;
        });
    }
}

