/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.MSDeployLogEntryType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MSDeployLogEntry
implements JsonSerializable<MSDeployLogEntry> {
    private OffsetDateTime time;
    private MSDeployLogEntryType type;
    private String message;

    public OffsetDateTime time() {
        return this.time;
    }

    public MSDeployLogEntryType type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MSDeployLogEntry fromJson(JsonReader jsonReader) throws IOException {
        return (MSDeployLogEntry)jsonReader.readObject(reader -> {
            MSDeployLogEntry deserializedMSDeployLogEntry = new MSDeployLogEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("time".equals(fieldName)) {
                    deserializedMSDeployLogEntry.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMSDeployLogEntry.type = MSDeployLogEntryType.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMSDeployLogEntry.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMSDeployLogEntry;
        });
    }
}

