/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import java.io.IOException;
import java.util.List;

public final class AppServicePlanCollection
implements JsonSerializable<AppServicePlanCollection> {
    private List<AppServicePlanInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AppServicePlanCollection.class);

    public List<AppServicePlanInner> value() {
        return this.value;
    }

    public AppServicePlanCollection withValue(List<AppServicePlanInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AppServicePlanCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AppServicePlanCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AppServicePlanCollection)jsonReader.readObject(reader -> {
            AppServicePlanCollection deserializedAppServicePlanCollection = new AppServicePlanCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAppServicePlanCollection.value = value = reader.readArray(reader1 -> AppServicePlanInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAppServicePlanCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServicePlanCollection;
        });
    }
}

