/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkerPool;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import java.io.IOException;
import java.util.List;

public final class WorkerPoolResourceInner
extends ProxyOnlyResource {
    private WorkerPool innerProperties;
    private SkuDescription sku;
    private String type;
    private String name;
    private String id;

    private WorkerPool innerProperties() {
        return this.innerProperties;
    }

    public SkuDescription sku() {
        return this.sku;
    }

    public WorkerPoolResourceInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public WorkerPoolResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Integer workerSizeId() {
        return this.innerProperties() == null ? null : this.innerProperties().workerSizeId();
    }

    public WorkerPoolResourceInner withWorkerSizeId(Integer workerSizeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withWorkerSizeId(workerSizeId);
        return this;
    }

    public ComputeModeOptions computeMode() {
        return this.innerProperties() == null ? null : this.innerProperties().computeMode();
    }

    public WorkerPoolResourceInner withComputeMode(ComputeModeOptions computeMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withComputeMode(computeMode);
        return this;
    }

    public String workerSize() {
        return this.innerProperties() == null ? null : this.innerProperties().workerSize();
    }

    public WorkerPoolResourceInner withWorkerSize(String workerSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withWorkerSize(workerSize);
        return this;
    }

    public Integer workerCount() {
        return this.innerProperties() == null ? null : this.innerProperties().workerCount();
    }

    public WorkerPoolResourceInner withWorkerCount(Integer workerCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkerPool();
        }
        this.innerProperties().withWorkerCount(workerCount);
        return this;
    }

    public List<String> instanceNames() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceNames();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static WorkerPoolResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkerPoolResourceInner)((Object)jsonReader.readObject(reader -> {
            WorkerPoolResourceInner deserializedWorkerPoolResourceInner = new WorkerPoolResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkerPoolResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkerPoolResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkerPoolResourceInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWorkerPoolResourceInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkerPoolResourceInner.innerProperties = WorkerPool.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedWorkerPoolResourceInner.sku = SkuDescription.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkerPoolResourceInner;
        }));
    }
}

