/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusProperties;
import com.azure.resourcemanager.appservice.models.MSDeployProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MSDeployStatusInner
extends ProxyOnlyResource {
    private MSDeployStatusProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private MSDeployStatusProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public MSDeployStatusInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String deployer() {
        return this.innerProperties() == null ? null : this.innerProperties().deployer();
    }

    public MSDeployProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public Boolean complete() {
        return this.innerProperties() == null ? null : this.innerProperties().complete();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MSDeployStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return (MSDeployStatusInner)((Object)jsonReader.readObject(reader -> {
            MSDeployStatusInner deserializedMSDeployStatusInner = new MSDeployStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMSDeployStatusInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMSDeployStatusInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMSDeployStatusInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedMSDeployStatusInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMSDeployStatusInner.innerProperties = MSDeployStatusProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMSDeployStatusInner;
        }));
    }
}

