// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gets the workflow trigger callback URL query parameters.
 */
@Fluent
public final class WorkflowTriggerListCallbackUrlQueries
    implements JsonSerializable<WorkflowTriggerListCallbackUrlQueries> {
    /*
     * The api version.
     */
    private String apiVersion;

    /*
     * The SAS permissions.
     */
    private String sp;

    /*
     * The SAS version.
     */
    private String sv;

    /*
     * The SAS signature.
     */
    private String sig;

    /*
     * The SAS timestamp.
     */
    private String se;

    /**
     * Creates an instance of WorkflowTriggerListCallbackUrlQueries class.
     */
    public WorkflowTriggerListCallbackUrlQueries() {
    }

    /**
     * Get the apiVersion property: The api version.
     * 
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /**
     * Set the apiVersion property: The api version.
     * 
     * @param apiVersion the apiVersion value to set.
     * @return the WorkflowTriggerListCallbackUrlQueries object itself.
     */
    public WorkflowTriggerListCallbackUrlQueries withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    /**
     * Get the sp property: The SAS permissions.
     * 
     * @return the sp value.
     */
    public String sp() {
        return this.sp;
    }

    /**
     * Set the sp property: The SAS permissions.
     * 
     * @param sp the sp value to set.
     * @return the WorkflowTriggerListCallbackUrlQueries object itself.
     */
    public WorkflowTriggerListCallbackUrlQueries withSp(String sp) {
        this.sp = sp;
        return this;
    }

    /**
     * Get the sv property: The SAS version.
     * 
     * @return the sv value.
     */
    public String sv() {
        return this.sv;
    }

    /**
     * Set the sv property: The SAS version.
     * 
     * @param sv the sv value to set.
     * @return the WorkflowTriggerListCallbackUrlQueries object itself.
     */
    public WorkflowTriggerListCallbackUrlQueries withSv(String sv) {
        this.sv = sv;
        return this;
    }

    /**
     * Get the sig property: The SAS signature.
     * 
     * @return the sig value.
     */
    public String sig() {
        return this.sig;
    }

    /**
     * Set the sig property: The SAS signature.
     * 
     * @param sig the sig value to set.
     * @return the WorkflowTriggerListCallbackUrlQueries object itself.
     */
    public WorkflowTriggerListCallbackUrlQueries withSig(String sig) {
        this.sig = sig;
        return this;
    }

    /**
     * Get the se property: The SAS timestamp.
     * 
     * @return the se value.
     */
    public String se() {
        return this.se;
    }

    /**
     * Set the se property: The SAS timestamp.
     * 
     * @param se the se value to set.
     * @return the WorkflowTriggerListCallbackUrlQueries object itself.
     */
    public WorkflowTriggerListCallbackUrlQueries withSe(String se) {
        this.se = se;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("api-version", this.apiVersion);
        jsonWriter.writeStringField("sp", this.sp);
        jsonWriter.writeStringField("sv", this.sv);
        jsonWriter.writeStringField("sig", this.sig);
        jsonWriter.writeStringField("se", this.se);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowTriggerListCallbackUrlQueries from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowTriggerListCallbackUrlQueries if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowTriggerListCallbackUrlQueries.
     */
    public static WorkflowTriggerListCallbackUrlQueries fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowTriggerListCallbackUrlQueries deserializedWorkflowTriggerListCallbackUrlQueries
                = new WorkflowTriggerListCallbackUrlQueries();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("api-version".equals(fieldName)) {
                    deserializedWorkflowTriggerListCallbackUrlQueries.apiVersion = reader.getString();
                } else if ("sp".equals(fieldName)) {
                    deserializedWorkflowTriggerListCallbackUrlQueries.sp = reader.getString();
                } else if ("sv".equals(fieldName)) {
                    deserializedWorkflowTriggerListCallbackUrlQueries.sv = reader.getString();
                } else if ("sig".equals(fieldName)) {
                    deserializedWorkflowTriggerListCallbackUrlQueries.sig = reader.getString();
                } else if ("se".equals(fieldName)) {
                    deserializedWorkflowTriggerListCallbackUrlQueries.se = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowTriggerListCallbackUrlQueries;
        });
    }
}
