// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Additional workflow properties.
 */
@Fluent
public final class WorkflowEnvelopeProperties implements JsonSerializable<WorkflowEnvelopeProperties> {
    /*
     * Gets or sets the files.
     */
    private Map<String, Object> files;

    /*
     * Gets or sets the state of the workflow.
     */
    private WorkflowState flowState;

    /*
     * Gets or sets workflow health.
     */
    private WorkflowHealth health;

    /**
     * Creates an instance of WorkflowEnvelopeProperties class.
     */
    public WorkflowEnvelopeProperties() {
    }

    /**
     * Get the files property: Gets or sets the files.
     * 
     * @return the files value.
     */
    public Map<String, Object> files() {
        return this.files;
    }

    /**
     * Set the files property: Gets or sets the files.
     * 
     * @param files the files value to set.
     * @return the WorkflowEnvelopeProperties object itself.
     */
    public WorkflowEnvelopeProperties withFiles(Map<String, Object> files) {
        this.files = files;
        return this;
    }

    /**
     * Get the flowState property: Gets or sets the state of the workflow.
     * 
     * @return the flowState value.
     */
    public WorkflowState flowState() {
        return this.flowState;
    }

    /**
     * Set the flowState property: Gets or sets the state of the workflow.
     * 
     * @param flowState the flowState value to set.
     * @return the WorkflowEnvelopeProperties object itself.
     */
    public WorkflowEnvelopeProperties withFlowState(WorkflowState flowState) {
        this.flowState = flowState;
        return this;
    }

    /**
     * Get the health property: Gets or sets workflow health.
     * 
     * @return the health value.
     */
    public WorkflowHealth health() {
        return this.health;
    }

    /**
     * Set the health property: Gets or sets workflow health.
     * 
     * @param health the health value to set.
     * @return the WorkflowEnvelopeProperties object itself.
     */
    public WorkflowEnvelopeProperties withHealth(WorkflowHealth health) {
        this.health = health;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (health() != null) {
            health().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("files", this.files, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("flowState", this.flowState == null ? null : this.flowState.toString());
        jsonWriter.writeJsonField("health", this.health);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowEnvelopeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowEnvelopeProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowEnvelopeProperties.
     */
    public static WorkflowEnvelopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowEnvelopeProperties deserializedWorkflowEnvelopeProperties = new WorkflowEnvelopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("files".equals(fieldName)) {
                    Map<String, Object> files = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedWorkflowEnvelopeProperties.files = files;
                } else if ("flowState".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.flowState = WorkflowState.fromString(reader.getString());
                } else if ("health".equals(fieldName)) {
                    deserializedWorkflowEnvelopeProperties.health = WorkflowHealth.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowEnvelopeProperties;
        });
    }
}
