// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the Twitter provider.
 */
@Fluent
public final class Twitter implements JsonSerializable<Twitter> {
    /*
     * <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise,
     * <code>true</code>.
     */
    private Boolean enabled;

    /*
     * The configuration settings of the app registration for the Twitter provider.
     */
    private TwitterRegistration registration;

    /**
     * Creates an instance of Twitter class.
     */
    public Twitter() {
    }

    /**
     * Get the enabled property: &lt;code&gt;false&lt;/code&gt; if the Twitter provider should not be enabled despite
     * the set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;false&lt;/code&gt; if the Twitter provider should not be enabled despite
     * the set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param enabled the enabled value to set.
     * @return the Twitter object itself.
     */
    public Twitter withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the registration property: The configuration settings of the app registration for the Twitter provider.
     * 
     * @return the registration value.
     */
    public TwitterRegistration registration() {
        return this.registration;
    }

    /**
     * Set the registration property: The configuration settings of the app registration for the Twitter provider.
     * 
     * @param registration the registration value to set.
     * @return the Twitter object itself.
     */
    public Twitter withRegistration(TwitterRegistration registration) {
        this.registration = registration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (registration() != null) {
            registration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", this.registration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Twitter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Twitter if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Twitter.
     */
    public static Twitter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Twitter deserializedTwitter = new Twitter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedTwitter.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("registration".equals(fieldName)) {
                    deserializedTwitter.registration = TwitterRegistration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTwitter;
        });
    }
}
