// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Identify the status of the most severe insight generated by the detector.
 */
@Fluent
public final class Status implements JsonSerializable<Status> {
    /*
     * Descriptive message.
     */
    private String message;

    /*
     * Level of the most severe insight generated by the detector.
     */
    private InsightStatus statusId;

    /**
     * Creates an instance of Status class.
     */
    public Status() {
    }

    /**
     * Get the message property: Descriptive message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Descriptive message.
     * 
     * @param message the message value to set.
     * @return the Status object itself.
     */
    public Status withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the statusId property: Level of the most severe insight generated by the detector.
     * 
     * @return the statusId value.
     */
    public InsightStatus statusId() {
        return this.statusId;
    }

    /**
     * Set the statusId property: Level of the most severe insight generated by the detector.
     * 
     * @param statusId the statusId value to set.
     * @return the Status object itself.
     */
    public Status withStatusId(InsightStatus statusId) {
        this.statusId = statusId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("statusId", this.statusId == null ? null : this.statusId.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Status from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Status if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Status.
     */
    public static Status fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Status deserializedStatus = new Status();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("message".equals(fieldName)) {
                    deserializedStatus.message = reader.getString();
                } else if ("statusId".equals(fieldName)) {
                    deserializedStatus.statusId = InsightStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStatus;
        });
    }
}
