// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A database connection configuration file.
 */
@Immutable
public final class StaticSiteDatabaseConnectionConfigurationFileOverview
    implements JsonSerializable<StaticSiteDatabaseConnectionConfigurationFileOverview> {
    /*
     * The name of the configuration file.
     */
    private String fileName;

    /*
     * The Base64 encoding of the file contents.
     */
    private String contents;

    /*
     * The type of configuration file.
     */
    private String type;

    /**
     * Creates an instance of StaticSiteDatabaseConnectionConfigurationFileOverview class.
     */
    public StaticSiteDatabaseConnectionConfigurationFileOverview() {
    }

    /**
     * Get the fileName property: The name of the configuration file.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Get the contents property: The Base64 encoding of the file contents.
     * 
     * @return the contents value.
     */
    public String contents() {
        return this.contents;
    }

    /**
     * Get the type property: The type of configuration file.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteDatabaseConnectionConfigurationFileOverview from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteDatabaseConnectionConfigurationFileOverview if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticSiteDatabaseConnectionConfigurationFileOverview.
     */
    public static StaticSiteDatabaseConnectionConfigurationFileOverview fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteDatabaseConnectionConfigurationFileOverview deserializedStaticSiteDatabaseConnectionConfigurationFileOverview
                = new StaticSiteDatabaseConnectionConfigurationFileOverview();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fileName".equals(fieldName)) {
                    deserializedStaticSiteDatabaseConnectionConfigurationFileOverview.fileName = reader.getString();
                } else if ("contents".equals(fieldName)) {
                    deserializedStaticSiteDatabaseConnectionConfigurationFileOverview.contents = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteDatabaseConnectionConfigurationFileOverview.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteDatabaseConnectionConfigurationFileOverview;
        });
    }
}
