// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An app cloneability criterion.
 */
@Fluent
public final class SiteCloneabilityCriterion implements JsonSerializable<SiteCloneabilityCriterion> {
    /*
     * Name of criterion.
     */
    private String name;

    /*
     * Description of criterion.
     */
    private String description;

    /**
     * Creates an instance of SiteCloneabilityCriterion class.
     */
    public SiteCloneabilityCriterion() {
    }

    /**
     * Get the name property: Name of criterion.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of criterion.
     * 
     * @param name the name value to set.
     * @return the SiteCloneabilityCriterion object itself.
     */
    public SiteCloneabilityCriterion withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Description of criterion.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of criterion.
     * 
     * @param description the description value to set.
     * @return the SiteCloneabilityCriterion object itself.
     */
    public SiteCloneabilityCriterion withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteCloneabilityCriterion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteCloneabilityCriterion if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteCloneabilityCriterion.
     */
    public static SiteCloneabilityCriterion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteCloneabilityCriterion deserializedSiteCloneabilityCriterion = new SiteCloneabilityCriterion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSiteCloneabilityCriterion.name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedSiteCloneabilityCriterion.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteCloneabilityCriterion;
        });
    }
}
