// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The workflow run action repetition index.
 */
@Fluent
public final class RepetitionIndex implements JsonSerializable<RepetitionIndex> {
    /*
     * The scope.
     */
    private String scopeName;

    /*
     * The index.
     */
    private int itemIndex;

    /**
     * Creates an instance of RepetitionIndex class.
     */
    public RepetitionIndex() {
    }

    /**
     * Get the scopeName property: The scope.
     * 
     * @return the scopeName value.
     */
    public String scopeName() {
        return this.scopeName;
    }

    /**
     * Set the scopeName property: The scope.
     * 
     * @param scopeName the scopeName value to set.
     * @return the RepetitionIndex object itself.
     */
    public RepetitionIndex withScopeName(String scopeName) {
        this.scopeName = scopeName;
        return this;
    }

    /**
     * Get the itemIndex property: The index.
     * 
     * @return the itemIndex value.
     */
    public int itemIndex() {
        return this.itemIndex;
    }

    /**
     * Set the itemIndex property: The index.
     * 
     * @param itemIndex the itemIndex value to set.
     * @return the RepetitionIndex object itself.
     */
    public RepetitionIndex withItemIndex(int itemIndex) {
        this.itemIndex = itemIndex;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("itemIndex", this.itemIndex);
        jsonWriter.writeStringField("scopeName", this.scopeName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RepetitionIndex from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RepetitionIndex if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RepetitionIndex.
     */
    public static RepetitionIndex fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RepetitionIndex deserializedRepetitionIndex = new RepetitionIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("itemIndex".equals(fieldName)) {
                    deserializedRepetitionIndex.itemIndex = reader.getInt();
                } else if ("scopeName".equals(fieldName)) {
                    deserializedRepetitionIndex.scopeName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRepetitionIndex;
        });
    }
}
