// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The access key regenerate action content.
 */
@Fluent
public final class RegenerateActionParameter implements JsonSerializable<RegenerateActionParameter> {
    /*
     * The key type.
     */
    private KeyType keyType;

    /**
     * Creates an instance of RegenerateActionParameter class.
     */
    public RegenerateActionParameter() {
    }

    /**
     * Get the keyType property: The key type.
     * 
     * @return the keyType value.
     */
    public KeyType keyType() {
        return this.keyType;
    }

    /**
     * Set the keyType property: The key type.
     * 
     * @param keyType the keyType value to set.
     * @return the RegenerateActionParameter object itself.
     */
    public RegenerateActionParameter withKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegenerateActionParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegenerateActionParameter if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegenerateActionParameter.
     */
    public static RegenerateActionParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegenerateActionParameter deserializedRegenerateActionParameter = new RegenerateActionParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyType".equals(fieldName)) {
                    deserializedRegenerateActionParameter.keyType = KeyType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegenerateActionParameter;
        });
    }
}
