// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines what this IP filter will be used for. This is to support IP filtering on proxies.
 */
public final class IpFilterTag extends ExpandableStringEnum<IpFilterTag> {
    /**
     * Static value Default for IpFilterTag.
     */
    public static final IpFilterTag DEFAULT = fromString("Default");

    /**
     * Static value XffProxy for IpFilterTag.
     */
    public static final IpFilterTag XFF_PROXY = fromString("XffProxy");

    /**
     * Static value ServiceTag for IpFilterTag.
     */
    public static final IpFilterTag SERVICE_TAG = fromString("ServiceTag");

    /**
     * Creates a new instance of IpFilterTag value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IpFilterTag() {
    }

    /**
     * Creates or finds a IpFilterTag from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IpFilterTag.
     */
    public static IpFilterTag fromString(String name) {
        return fromString(name, IpFilterTag.class);
    }

    /**
     * Gets known IpFilterTag values.
     * 
     * @return known IpFilterTag values.
     */
    public static Collection<IpFilterTag> values() {
        return values(IpFilterTag.class);
    }
}
